/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.sminvoice.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.GetSmInvoiceListRequest;
import com.xforceplus.vanke.in.client.model.SmInvoiceDTO;
import com.xforceplus.vanke.in.repository.dao.SmInvoiceDao;
import com.xforceplus.vanke.in.repository.model.SmInvoiceExample;
import com.xforceplus.vanke.sc.base.enums.invoice.DeleteTypeEnum;
import com.xforceplus.vanke.sc.base.exception.VankeException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetSmInvoiceListProcess
extends AbstractProcess<GetSmInvoiceListRequest, ListResult<SmInvoiceDTO>> {
    @Autowired
    private SmInvoiceDao smInvoiceDao;

    protected CommonResponse<ListResult<SmInvoiceDTO>> process(GetSmInvoiceListRequest request) throws RuntimeException {
        SmInvoiceExample smInvoiceExample = this.createExample(request);
        smInvoiceExample.setLimit(request.getRows());
        smInvoiceExample.setOffset(request.getOffset());
        ListResult listResult = new ListResult(Long.valueOf(this.smInvoiceDao.countByExample(smInvoiceExample)), this.smInvoiceDao.selectByExample(smInvoiceExample).stream().map(entity -> {
            SmInvoiceDTO dto = new SmInvoiceDTO();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
    }

    public SmInvoiceExample createExample(GetSmInvoiceListRequest request) {
        SmInvoiceExample smInvoiceExample = new SmInvoiceExample();
        SmInvoiceExample.Criteria criteria = smInvoiceExample.createCriteria();
        if (ValidatorUtil.isNotEmpty((Object)request.getFpzt())) {
            criteria.andFpztEqualTo(request.getFpzt());
        }
        if (ValidatorUtil.isNotEmpty((String)request.getOrderCode())) {
            criteria.andOrderCodeEqualTo(request.getOrderCode());
        }
        if (ValidatorUtil.isNotEmpty((String)request.getInvoiceNo())) {
            criteria.andBillNumberEqualTo(request.getInvoiceNo());
        }
        if (ValidatorUtil.isNotEmpty((String)request.getInvoiceCode())) {
            criteria.andBillCodeEqualTo(request.getInvoiceCode());
        }
        if (ValidatorUtil.isNotEmpty((Object)request.getDeleteType())) {
            DeleteTypeEnum deleteTypeEnum = DeleteTypeEnum.fromCode((Integer)request.getDeleteType());
            if (deleteTypeEnum == null) {
                throw new VankeException("\u5220\u9664\u539f\u56e0\u4f20\u5165\u5f02\u5e38!" + request.getDeleteType());
            }
            criteria.andDeleteTypeEqualTo(deleteTypeEnum.getCode());
        }
        if (ValidatorUtil.isNotEmpty((String)request.getDeleteUser())) {
            criteria.andDeleteUserEqualTo(request.getDeleteUser());
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getCreateTime()) && request.getCreateTime().size() == 2) {
            criteria.andCreateTimeBetween(new Date((Long)request.getCreateTime().get(0)), new Date((Long)request.getCreateTime().get(1)));
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getDeleteTime()) && request.getDeleteTime().size() == 2) {
            criteria.andDeleteTimeBetween(new Date((Long)request.getDeleteTime().get(0)), new Date((Long)request.getDeleteTime().get(1)));
        }
        criteria.andDeleteUserNotIn(Arrays.asList("", "\u7cfb\u7edf"));
        smInvoiceExample.setOrderByClause("deleteTime desc");
        return smInvoiceExample;
    }
}

