/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.workbench.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.WorkBenchResultBean;
import com.xforceplus.vanke.in.repository.daoext.ReportDaoExt;
import com.xforceplus.vanke.sc.service.MenuBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetCountProcess
extends AbstractProcess<BaseRequest, List<WorkBenchResultBean>> {
    @Autowired
    private ReportDaoExt reportDaoExt;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private MenuBusiness menuBusiness;

    protected CommonResponse<List<WorkBenchResultBean>> process(BaseRequest request) throws RuntimeException {
        long start = System.currentTimeMillis();
        ArrayList list = Lists.newArrayList();
        UserSessionInfo userInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        String userName = userInfo.getSysUserName();
        List sysMenuEntities = this.menuBusiness.getSysMenuList(userInfo);
        ArrayList futures = new ArrayList();
        sysMenuEntities.forEach(sysMenuEntity -> {
            switch (sysMenuEntity.getMenuPath()) {
                case "/postcode": {
                    futures.add(CompletableFuture.runAsync(() -> this.getData(this.reportDaoExt.getPostcodeDayCount(userName), "\u90ae\u5305\u7b7e\u6536", list, 0)));
                    futures.add(CompletableFuture.runAsync(() -> this.getData(this.reportDaoExt.getOrdersDayCount(userName), "\u4e1a\u52a1\u5355\u7b7e\u6536", list, 1)));
                    futures.add(CompletableFuture.runAsync(() -> this.getData(this.reportDaoExt.getInvoiceDayCount(userName), "\u53d1\u7968\u7b7e\u6536", list, 2)));
                    break;
                }
                case "/scan": {
                    futures.add(CompletableFuture.runAsync(() -> this.getData(this.reportDaoExt.getImageDayCount(userName), "\u5f71\u50cf\u4e0a\u4f20", list, 3)));
                    break;
                }
                case "/invoiceAuth": {
                    futures.add(CompletableFuture.runAsync(() -> this.getData(this.reportDaoExt.getAuthDayCount(userName), "\u53d1\u7968\u52fe\u9009", list, 5)));
                    break;
                }
                case "/abnormal": {
                    futures.add(CompletableFuture.runAsync(() -> this.getData(this.reportDaoExt.getExceptionDayCount(userName), "\u5f02\u5e38\u5904\u7406", list, 4)));
                    break;
                }
            }
        });
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).join();
        list.sort(Comparator.comparing(WorkBenchResultBean::getOrderNo));
        this.logger.info("=====\u83b7\u53d6Count\u603b\u8017\u65f6{}ms", (Object)(System.currentTimeMillis() - start));
        return CommonResponse.ok((String)"", (Object)list);
    }

    public void getData(List<Map<String, Object>> countList, String name, List<WorkBenchResultBean> list, int orderNo) {
        List dayList = this.getDay(Integer.valueOf(14));
        for (int i = 0; i < dayList.size(); ++i) {
            boolean addFlag = true;
            for (Map<String, Object> hs : countList) {
                if (!((String)dayList.get(i)).equals(hs.get("allTime"))) continue;
                addFlag = false;
            }
            if (!addFlag) continue;
            String day = (String)dayList.get(i);
            countList.add(i, (Map<String, Object>)new /* Unavailable Anonymous Inner Class!! */);
        }
        List collect = countList.stream().sorted(Comparator.comparing(GetCountProcess::comparingByAllTime)).collect(Collectors.toList());
        WorkBenchResultBean workBenchResultBean = new WorkBenchResultBean();
        workBenchResultBean.setName(name);
        workBenchResultBean.setData(collect);
        workBenchResultBean.setOrderNo(orderNo);
        list.add(workBenchResultBean);
    }

    List<String> getDay(Integer day) {
        ArrayList days = Lists.newArrayList();
        for (int i = 0; i < day; ++i) {
            days.add(DateHelp.getNowDateIntervalDaysLater((int)(-i)));
        }
        return days;
    }

    private static String comparingByAllTime(Map<String, Object> map) {
        return (String)map.get("allTime");
    }
}

