/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.DeleteInvoiceImagesRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.sync.tools.InvoiceSyncMainTools;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.CommonTools;
import com.xforceplus.vanke.sc.repository.model.SysConfigEntity;
import com.xforceplus.vanke.sc.service.ConfigBusiness;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DeleteInvoiceProcess
extends AbstractProcess<DeleteInvoiceImagesRequest, Boolean> {
    @Autowired
    private ConfigBusiness configBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private InvoiceSyncMainTools invoiceSyncMainTools;

    protected CommonResponse<Boolean> process(DeleteInvoiceImagesRequest request) throws RuntimeException {
        List invoiceIds = request.getInvoiceIds();
        if (CommonTools.isEmpty((List)invoiceIds)) {
            return CommonResponse.failed((String)"\u53d1\u7968id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List invoiceEntities = this.invoiceBusiness.getInvoiceListByParams(invoiceIds, null);
        if (CollectionUtils.isEmpty((Collection)invoiceEntities)) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u627e\u5230\u53ef\u64cd\u4f5c\u7684\u53d1\u7968.");
        }
        List collect = invoiceEntities.stream().filter(x -> x.getCooperateFlag() == 1).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            return CommonResponse.failed((String)"\u534f\u540c\u53d1\u7968\u65e0\u6cd5\u5220\u9664!");
        }
        SysConfigEntity configEntity = this.configBusiness.getButtonPremiss("deleteInvoiceInfo");
        if (null == configEntity) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u64cd\u4f5c\u5220\u9664\u53d1\u7968\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5.");
        }
        if (!configEntity.getConfigValue().contains(String.valueOf(userSessionInfo.getSysUserId()))) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u64cd\u4f5c\u5220\u9664\u53d1\u7968\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5.");
        }
        WkInvoiceExample wkInvoiceExample = new WkInvoiceExample();
        wkInvoiceExample.createCriteria().andIdIn(invoiceIds);
        WkInvoiceEntity wkInvoiceEntity = new WkInvoiceEntity();
        wkInvoiceEntity.setStatus(Integer.valueOf(9));
        this.wkInvoiceDao.updateByExampleSelective(wkInvoiceEntity, wkInvoiceExample);
        List salesbillNos = invoiceEntities.stream().map(WkInvoiceEntity::getSalesbillNo).distinct().collect(Collectors.toList());
        salesbillNos.stream().forEach(r -> this.invoiceSyncMainTools.checkOrderAuthTime(r));
        invoiceEntities.stream().forEach(x -> this.logOperationsBusiness.saveLogOperations(x.getSalesbillNo(), OpsTypeEnum.DELETE_INVOICE_INFO.getCode(), userSessionInfo.getSysUserName(), OpsTypeEnum.DELETE_INVOICE_INFO.getName() + ": " + request.getDeleteMessage(), x.getInvoiceNo(), x.getInvoiceCode()));
        return CommonResponse.ok((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

