/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.xforceplus.landedestate.basecommon.help.lang.DateConvert;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.InvoiceInfoRequest;
import com.xforceplus.vanke.in.client.model.InvoiceStatusLifeCycleBean;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.repository.model.WkPostcodeEntity;
import com.xforceplus.vanke.in.service.orders.OrdersBusiness;
import com.xforceplus.vanke.in.service.postcode.PostcodeBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.invoice.AuthStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.SpecialInvoiceFlagEnum;
import java.util.Collection;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetInvoiceStatusLifeCycleProcess
extends AbstractProcess<InvoiceInfoRequest, InvoiceStatusLifeCycleBean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private PostcodeBusiness postcodeBusiness;
    @Autowired
    private OrdersBusiness ordersBusiness;

    protected void check(InvoiceInfoRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getInvoiceId(), "\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<InvoiceStatusLifeCycleBean> process(InvoiceInfoRequest request) throws RuntimeException {
        InvoiceStatusLifeCycleBean cycleBean = new InvoiceStatusLifeCycleBean();
        WkInvoiceEntity invoiceEntity = this.wkInvoiceDao.selectByPrimaryKey(request.getInvoiceId());
        if (null == invoiceEntity) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u627e\u5230\u53d1\u7968\u4fe1\u606f.");
        }
        cycleBean.setSellerSyncStatus(invoiceEntity.getSellerSyncStatus());
        cycleBean.setSellerSyncTime(Long.valueOf(invoiceEntity.getSellerSyncTime().getTime()));
        cycleBean.setSellerSyncName(invoiceEntity.getSellerUserName());
        if (StringHelp.safeIsEmpty((Object)invoiceEntity.getPackageCode())) {
            this.setPackageInfo(cycleBean, Constants.NUMBER_ZERO, Constants.DEFAULT_TIME.longValue(), "");
        } else {
            List postcodeEntities = this.postcodeBusiness.getListByPackageCode(invoiceEntity.getPackageCode());
            if (CollectionUtils.isEmpty((Collection)postcodeEntities)) {
                this.setPackageInfo(cycleBean, Constants.NUMBER_ZERO, Constants.DEFAULT_TIME.longValue(), "");
            } else {
                WkPostcodeEntity postcodeEntity = (WkPostcodeEntity)postcodeEntities.get(0);
                this.setPackageInfo(cycleBean, postcodeEntity.getRecieveStatus(), postcodeEntity.getRecieveTime().getTime(), postcodeEntity.getReciever());
            }
        }
        if (StringHelp.safeIsEmpty((Object)invoiceEntity.getSalesbillNo())) {
            this.setInvoiceInfo(cycleBean, Constants.NUMBER_ZERO, Constants.DEFAULT_TIME.longValue(), "");
        } else {
            List ordersEntities = this.ordersBusiness.selectBySelect(invoiceEntity.getSalesbillNo(), null);
            if (CollectionUtils.isEmpty((Collection)ordersEntities)) {
                this.setInvoiceInfo(cycleBean, Constants.NUMBER_ZERO, Constants.DEFAULT_TIME.longValue(), "");
            } else {
                WkOrdersEntity ordersEntity = (WkOrdersEntity)ordersEntities.get(0);
                this.setInvoiceInfo(cycleBean, ordersEntity.getSignStatus(), ordersEntity.getSignTime().getTime(), ordersEntity.getSignPerson());
            }
        }
        cycleBean.setRecogStatus(invoiceEntity.getRecogStatus());
        cycleBean.setRecogTime(Long.valueOf(invoiceEntity.getRecogResponseTime().getTime()));
        cycleBean.setRecogName(invoiceEntity.getRecogUserName());
        cycleBean.setAuditStatus(invoiceEntity.getAuditStatus());
        cycleBean.setAuditTime(invoiceEntity.getAuditUpdateTime().getTime());
        cycleBean.setAuditName(invoiceEntity.getAuditUser());
        boolean flag = false;
        if (InvoiceTypeEnum.SPECIAL.value().equals(invoiceEntity.getInvoiceType()) || InvoiceTypeEnum.VEHICLE.value().equals(invoiceEntity.getInvoiceType()) || InvoiceTypeEnum.TRAFFIC.value().equals(invoiceEntity.getInvoiceType()) && SpecialInvoiceFlagEnum.TOLL.getCode().equals(invoiceEntity.getSpecialInvoiceFlag())) {
            cycleBean.setAuthStatus(invoiceEntity.getAuthStatus());
            if (AuthStatusEnum.CHECKED.getCode().equals(invoiceEntity.getAuthStatus()) || AuthStatusEnum.CHECK_ABNORMAL.getCode().equals(invoiceEntity.getAuthStatus()) || AuthStatusEnum.FAILED.getCode().equals(invoiceEntity.getAuthStatus())) {
                cycleBean.setAuthTime(Long.valueOf(invoiceEntity.getAuthCheckResponseTime().getTime()));
            } else if (AuthStatusEnum.SUCCEED.getCode().equals(invoiceEntity.getAuthStatus()) || AuthStatusEnum.ABNORMAL.getCode().equals(invoiceEntity.getAuthStatus())) {
                cycleBean.setAuthTime(Long.valueOf(invoiceEntity.getAuthReturnTime().getTime()));
            } else {
                cycleBean.setAuthTime(Constants.DEFAULT_TIME);
            }
            cycleBean.setAuthName(invoiceEntity.getAuthRequestUserName());
            cycleBean.setAuthRemark(invoiceEntity.getAuthRemark());
            cycleBean.setAuthStyle(invoiceEntity.getAuthStyle());
            cycleBean.setAuthTaxPeriod(invoiceEntity.getAuthTaxPeriod());
            flag = true;
        }
        cycleBean.setSellerDateStr(DateHelp.getStringTimeDiffStr((long)cycleBean.getSellerSyncTime(), (long)cycleBean.getPackageSignTime()));
        cycleBean.setPackageSignDateStr(DateHelp.getStringTimeDiffStr((long)cycleBean.getPackageSignTime(), (long)cycleBean.getInvoiceSignTime()));
        cycleBean.setInvoiceSignDateStr(DateHelp.getStringTimeDiffStr((long)cycleBean.getInvoiceSignTime(), (long)cycleBean.getRecogTime()));
        long lastTime = Constants.DEFAULT_TIME;
        if (!flag) {
            if (!Constants.DEFAULT_TIME.equals(cycleBean.getRecogTime())) {
                lastTime = !Constants.DEFAULT_TIME.equals(cycleBean.getAuditTime()) ? cycleBean.getAuditTime() : DateConvert.getNowDate().getTime();
            }
            cycleBean.setRecogDateStr(DateHelp.getStringTimeDiffStr((long)cycleBean.getRecogTime(), (long)lastTime));
        } else {
            cycleBean.setRecogDateStr(DateHelp.getStringTimeDiffStr((long)cycleBean.getRecogTime(), (long)cycleBean.getAuditTime()));
            if (!Constants.DEFAULT_TIME.equals(cycleBean.getAuditTime())) {
                lastTime = !Constants.DEFAULT_TIME.equals(cycleBean.getAuthTime()) ? cycleBean.getAuthTime().longValue() : DateConvert.getNowDate().getTime();
            }
            cycleBean.setAuditDateStr(DateHelp.getStringTimeDiffStr((long)cycleBean.getAuditTime(), (long)lastTime));
        }
        cycleBean.setShowAuthFlag(Boolean.valueOf(flag));
        if (AuthStatusEnum.NOT_AUTH.getCode().equals(invoiceEntity.getAuthStatus()) || AuthStatusEnum.FAILED.getCode().equals(invoiceEntity.getAuthStatus()) || AuthStatusEnum.DEFAULT.getCode().equals(invoiceEntity.getAuthStatus()) || AuthStatusEnum.CAN_NOT_AUTH.getCode().equals(invoiceEntity.getAuthStatus()) || AuthStatusEnum.CHECKED.getCode().equals(invoiceEntity.getAuthStatus())) {
            cycleBean.setModifyAuthFlag(Boolean.valueOf(true));
        } else {
            cycleBean.setModifyAuthFlag(Boolean.valueOf(false));
        }
        return CommonResponse.ok((String)"\u6210\u529f", (Object)cycleBean);
    }

    private void setPackageInfo(InvoiceStatusLifeCycleBean cycleBean, Integer status, long time, String name) {
        cycleBean.setPackageSignStatus(status);
        cycleBean.setPackageSignTime(Long.valueOf(time));
        cycleBean.setPackageSignName(name);
    }

    private void setInvoiceInfo(InvoiceStatusLifeCycleBean cycleBean, Integer status, long time, String name) {
        cycleBean.setInvoiceSignStatus(status);
        cycleBean.setInvoiceSignTime(Long.valueOf(time));
        cycleBean.setInvoiceSignName(name);
    }
}

