/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.GetInvoiceListRequest;
import com.xforceplus.vanke.in.controller.invoice.tool.ThreadPoolManager;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.service.invoice.InvoiceFilterBusiness;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceExportBusiness;
import com.xforceplus.vanke.sc.base.enums.invoice.ExportTypeEnum;
import com.xforceplus.vanke.sc.base.exception.VankeException;
import com.xforceplus.vanke.sc.service.FileBusiness;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceExportProcess
extends AbstractProcess<GetInvoiceListRequest, Boolean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private InvoiceFilterBusiness invoiceFilterBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private InvoiceExportBusiness invoiceExportBusiness;
    @Autowired
    private FileBusiness fileBusiness;
    private static final Integer MAX_LINE_LENGTH = 50000;

    protected void check(GetInvoiceListRequest request) throws ValidationException {
        long day;
        super.check((BaseRequest)request);
        boolean isEmpty = false;
        try {
            isEmpty = ValidatorUtil.allFieldEmpty((Object)request);
        }
        catch (Exception e) {
            this.logger.error("\u5224\u65ad\u53c2\u6570\u662f\u5426\u4e3a\u7a7a\u5f02\u5e38!");
        }
        if (isEmpty) {
            throw new VankeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u90fd\u4e3a\u7a7a!");
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getPaperDrewDate()) && (day = ((Long)request.getPaperDrewDate().get(1) - (Long)request.getPaperDrewDate().get(0)) / 86400000L) > 365L) {
            throw new VankeException("\u9009\u62e9\u65e5\u671f\u4e0d\u53ef\u5927\u4e8e\u4e00\u5e74\u524d!");
        }
    }

    private String getPich() {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        String maxPich = this.messageBusiness.getMaxPichByUserID(Long.valueOf(userSessionInfo.getSysUserId()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String date = sdf.format(new Date());
        if (StringUtils.isBlank((CharSequence)maxPich)) {
            return date + "_0001";
        }
        String[] s = maxPich.split("_");
        if (null != s) {
            String maxDate = s[0];
            String pich = s[1];
            if (!date.equals(maxDate)) {
                return date + "_0001";
            }
            return maxDate + "_" + String.format("%04d", Integer.parseInt(pich) + 1);
        }
        return date + "_0001";
    }

    protected CommonResponse<Boolean> process(GetInvoiceListRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String pich = this.getPich();
        String downloadName = ExportTypeEnum.INVOICE.getName();
        CompletableFuture.runAsync(() -> {
            Date date = new Date();
            WkInvoiceExample example1 = new WkInvoiceExample();
            WkInvoiceExample.Criteria criteria1 = example1.createCriteria();
            this.invoiceFilterBusiness.setInvoiceFilterExample(criteria1, request);
            long count = this.wkInvoiceDao.countByExample(example1);
            if (count == 0L) {
                this.invoiceExportBusiness.setEmptyMsg(downloadName, userSessionInfo);
                return;
            }
            long index = count / (long)MAX_LINE_LENGTH.intValue();
            long remainder = count % (long)MAX_LINE_LENGTH.intValue();
            if (remainder > 0L) {
                ++index;
            }
            long endIndex = 0L;
            ThreadPoolExecutor instance = ThreadPoolManager.getInstance();
            int j = 0;
            while ((long)j < index) {
                WkInvoiceExample example = new WkInvoiceExample();
                WkInvoiceExample.Criteria criteria = example.createCriteria();
                this.invoiceFilterBusiness.setInvoiceFilterExample(criteria, request);
                long beginIndex = j * MAX_LINE_LENGTH;
                example.setOffset(Integer.valueOf((int)beginIndex));
                example.setLimit(MAX_LINE_LENGTH);
                instance.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                ++j;
            }
        });
        return CommonResponse.ok((String)"\u5bfc\u51fa\u6210\u529f,\u8bf7\u5728\u53f3\u4e0a\u89d2\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b!");
    }

    static /* synthetic */ WkInvoiceDao access$000(InvoiceExportProcess x0) {
        return x0.wkInvoiceDao;
    }

    static /* synthetic */ Logger access$100(InvoiceExportProcess x0) {
        return x0.logger;
    }

    static /* synthetic */ InvoiceExportBusiness access$200(InvoiceExportProcess x0) {
        return x0.invoiceExportBusiness;
    }

    static /* synthetic */ Logger access$300(InvoiceExportProcess x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$400(InvoiceExportProcess x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$500(InvoiceExportProcess x0) {
        return x0.logger;
    }

    static /* synthetic */ FileBusiness access$600(InvoiceExportProcess x0) {
        return x0.fileBusiness;
    }

    static /* synthetic */ Logger access$700(InvoiceExportProcess x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$800(InvoiceExportProcess x0) {
        return x0.logger;
    }

    static /* synthetic */ MessageBusiness access$900(InvoiceExportProcess x0) {
        return x0.messageBusiness;
    }

    static /* synthetic */ Logger access$1000(InvoiceExportProcess x0) {
        return x0.logger;
    }
}

