/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.alibaba.fastjson.JSON;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.InvoiceInfoRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceImportBusiness;
import com.xforceplus.vanke.in.service.invoice.sync.tools.InvoiceSyncMainTools;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.IsOrNo;
import com.xforceplus.vanke.sc.base.enums.company.AuthTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.AuthStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.AuthStyleEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceTypeEnum;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonEntity;
import com.xforceplus.vanke.sc.service.LegalPersonBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModifyAuthProcess
extends AbstractProcess<InvoiceInfoRequest, Boolean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private InvoiceImportBusiness invoiceImportBusiness;
    @Autowired
    private InvoiceSyncMainTools invoiceSyncMainTools;
    @Autowired
    private LegalPersonBusiness legalPersonBusiness;

    protected void check(InvoiceInfoRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getInvoiceId(), "\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty((Object)request.getAuthResult(), "\u62b5\u6263\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        if (!(Constants.NUMBER_ZERO.equals(request.getAuthResult()) || Constants.NUMBER_ONE.equals(request.getAuthResult()) || Constants.NUMBER_TWO.equals(request.getAuthResult()))) {
            throw new ValidationException("\u62b5\u6263\u7ed3\u679c\u4f20\u53c2\u4e0d\u5408\u6cd5:0-\u672a\u52fe\u9009 1-\u5df2\u52fe\u9009 2-\u5df2\u62b5\u6263");
        }
        if (Constants.NUMBER_ONE.equals(request.getAuthResult()) || Constants.NUMBER_TWO.equals(request.getAuthResult())) {
            this.checkEmpty((Object)request.getAuthStyle(), "\u62b5\u6263\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Constants.NUMBER_TWO.equals(request.getAuthResult())) {
            this.checkEmpty(request.getTaxPeriod(), "\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            if (!AuthStyleEnum.PYT_ACCOUNT_CERTIFY_IMPORT.getCode().equals(request.getAuthStyle()) && !AuthStyleEnum.PYT_SCAN_CERTIFY_IMPORT.getCode().equals(request.getAuthStyle())) {
                throw new ValidationException("\u62b5\u6263\u65b9\u5f0f\u4f20\u53c2\u4e0d\u5408\u6cd5\uff1a11-\u5e95\u8d26\u62b5\u6263\uff1b21-\u626b\u63cf\u62b5\u6263.");
            }
        }
        if (!StringHelp.safeIsEmpty((Object)request.getAuthTime()) && !ValidatorUtil.isTimestamp((String)request.getAuthTime(), (String)"yyyy/MM/dd HH:mm")) {
            throw new ValidationException("\u62b5\u6263\u65f6\u95f4\u4e0d\u5408\u6cd5,\u683c\u5f0f\uff1ayyyy/MM/dd HH:mm");
        }
    }

    protected CommonResponse process(InvoiceInfoRequest request) throws RuntimeException {
        WkInvoiceEntity entity = this.wkInvoiceDao.selectByPrimaryKey(request.getInvoiceId());
        if (null == entity) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u627e\u5230\u53ef\u64cd\u4f5c\u7684\u53d1\u7968.");
        }
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(AuthStatusEnum.NOT_AUTH.getCode().equals(entity.getAuthStatus()) || AuthStatusEnum.FAILED.getCode().equals(entity.getAuthStatus()) || AuthStatusEnum.DEFAULT.getCode().equals(entity.getAuthStatus()) || AuthStatusEnum.CAN_NOT_AUTH.getCode().equals(entity.getAuthStatus()) || Constants.NUMBER_ONE.equals(request.getAuthResult()) || Constants.NUMBER_TWO.equals(request.getAuthResult()) && (AuthStatusEnum.SUCCEED.getCode().equals(entity.getAuthStatus()) || AuthStatusEnum.CHECKED.getCode().equals(entity.getAuthStatus())))) {
            return CommonResponse.failed((String)"\u53d1\u7968\u4e0d\u6ee1\u8db3\u4fee\u6539\u62b5\u6263\u72b6\u6001\u6761\u4ef6.");
        }
        if (Constants.NUMBER_ONE.equals(request.getAuthResult()) || Constants.NUMBER_TWO.equals(request.getAuthResult())) {
            WkLegalPersonEntity legalEntity;
            if (AuthStatusEnum.IN_AUTH.getCode().equals(entity.getAuthStatus())) {
                return CommonResponse.failed((String)"\u53d1\u7968\u52fe\u9009\u4e2d\u4e0d\u53ef\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5.");
            }
            if (!InvoiceTypeEnum.SPECIAL.value().equals(entity.getInvoiceType())) {
                return CommonResponse.failed((String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u53ef\u62b5\u6263\uff0c\u8bf7\u68c0\u67e5.");
            }
            if (!StringHelp.safeIsEmpty((Object)entity.getPaperDrewDate())) {
                String paperDrewDateStr = entity.getPaperDrewDate().substring(0, 6);
                if (request.getTaxPeriod().compareTo(paperDrewDateStr) < 0) {
                    return CommonResponse.failed((String)"\u6240\u5c5e\u671f\u9700\u5927\u4e8e\u5f00\u7968\u65e5\u671f\u6708\u4efd\uff0c\u8bf7\u68c0\u67e5.");
                }
            }
            if (null != (legalEntity = this.legalPersonBusiness.getLegalPersonListByRelTax(entity.getPurchaserTaxNo())) && null != legalEntity.getIsBlockade() && IsOrNo.YES.getCode().equals(legalEntity.getIsBlockade()) && (AuthTypeEnum.ELECTRONIC_ACCOUNT.getCode().equals(legalEntity.getAuthType()) || AuthTypeEnum.ALL_OK.getCode().equals(legalEntity.getAuthType()))) {
                return CommonResponse.failed((String)"\u53d1\u7968\u6240\u5c5e\u8d2d\u65b9\u7a0e\u53f7\u5904\u4e8e\u5c01\u9501\u4e2d\u4e0d\u53ef\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5.");
            }
            this.invoiceImportBusiness.updateAuthStatusSuccess(entity, userSessionInfo, request.getTaxPeriod(), request.getAuthTime(), request.getAuthStyle(), request.getAuthResult(), "yyyy/MM/dd HH:mm", JSON.toJSONString((Object)request));
        }
        if (Constants.NUMBER_ZERO.equals(request.getAuthResult())) {
            this.invoiceImportBusiness.cancelAuth(entity, userSessionInfo);
        }
        if (!StringHelp.safeIsEmpty((Object)entity.getSalesbillNo())) {
            this.invoiceSyncMainTools.checkOrderAuthTime(entity.getSalesbillNo());
        }
        return CommonResponse.ok((String)"\u4fee\u6539\u62b5\u6263\u72b6\u6001\u6210\u529f.");
    }
}

