/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.PushInvoiceRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.XtInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.XtInvoiceEntity;
import com.xforceplus.vanke.in.service.invoice.XtInvoiceBusiness;
import com.xforceplus.vanke.in.service.job.assembleData.AssembleTools;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.DataFromSystemEnum;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.invoicefp.v1.InvoiceInfo;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.invoicefp.v1.RtnInfo;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.invoicefpservice.InvoiceRQ;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.invoicefpservice.InvoiceRS;
import com.xforceplus.vanke.sc.outer.pdc.PDCInterfaceImpl;
import com.xforceplus.vanke.sc.outer.sap.SAPInterfaceImpl;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.vanke.sc.utils.QueueSender;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PushInvoiceInfoProcess
extends AbstractProcess<PushInvoiceRequest, Boolean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private PDCInterfaceImpl pdcInterfaceImpl;
    @Autowired
    private XtInvoiceBusiness xtInvoiceBusiness;
    @Autowired
    private SAPInterfaceImpl sapInterfaceImpl;
    @Autowired
    private QueueSender queueSender;
    @Autowired
    private XtInvoiceDao xtInvoiceDao;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(PushInvoiceRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getPushType(), "\u63a8\u9001\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a! 1-\u4f5c\u5e9f\u4fe1\u606f 2-\u5f00\u7968\u4fe1\u606f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommonResponse<Boolean> process(PushInvoiceRequest request) throws RuntimeException {
        List<WkInvoiceEntity> list;
        block17: {
            list = Arrays.asList(this.wkInvoiceDao.selectByPrimaryKey(request.getInvoiceId()));
            if (ValidatorUtil.isEmpty(list)) {
                return CommonResponse.failed((String)"\u672a\u627e\u5230\u8be5\u53d1\u7968\u4fe1\u606f!");
            }
            try {
                if (DataFromSystemEnum.PDC.getCode().equals(request.getSysOrign())) {
                    switch (request.getPushType()) {
                        case 1: {
                            this.cancelInvoiceInfoPDC(list, "0");
                            break;
                        }
                        case 2: {
                            this.cancelInvoiceInfoPDC(list, "1");
                            break;
                        }
                    }
                    break block17;
                }
                if (!DataFromSystemEnum.SAP.getCode().equals(request.getSysOrign())) break block17;
                switch (request.getPushType()) {
                    case 1: {
                        this.cancelInvoiceInfoSAP(list.get(0), "0");
                        break;
                    }
                    case 2: {
                        this.cancelInvoiceInfoSAP(list.get(0), "1");
                    }
                }
            }
            catch (Exception e) {
                try {
                    this.logger.info("\u63a8\u9001\u5931\u8d25!{}", (Object)e.getMessage());
                    CommonResponse.failed((String)"\u63a8\u9001\u5931\u8d25!");
                }
                catch (Throwable throwable) {
                    if (ValidatorUtil.isNotEmpty(list)) {
                        String opsMessage = Integer.valueOf(1).equals(request.getPushType()) ? "\u63a8\u9001\u4f5c\u5e9f\u4fe1\u606f" : "\u63a8\u9001\u5f00\u7968\u4fe1\u606f";
                        this.logOperationsBusiness.saveLogOperations(CollectionUtils.isEmpty(list) ? null : list.get(0).getSalesbillNo(), OpsTypeEnum.PUSH_INVOICE.getCode(), ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserName(), opsMessage, list.get(0).getInvoiceNo(), list.get(0).getInvoiceCode());
                    }
                    throw throwable;
                }
                if (ValidatorUtil.isNotEmpty(list)) {
                    String opsMessage = Integer.valueOf(1).equals(request.getPushType()) ? "\u63a8\u9001\u4f5c\u5e9f\u4fe1\u606f" : "\u63a8\u9001\u5f00\u7968\u4fe1\u606f";
                    this.logOperationsBusiness.saveLogOperations(CollectionUtils.isEmpty(list) ? null : list.get(0).getSalesbillNo(), OpsTypeEnum.PUSH_INVOICE.getCode(), ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserName(), opsMessage, list.get(0).getInvoiceNo(), list.get(0).getInvoiceCode());
                }
            }
        }
        if (ValidatorUtil.isNotEmpty(list)) {
            String opsMessage = Integer.valueOf(1).equals(request.getPushType()) ? "\u63a8\u9001\u4f5c\u5e9f\u4fe1\u606f" : "\u63a8\u9001\u5f00\u7968\u4fe1\u606f";
            this.logOperationsBusiness.saveLogOperations(CollectionUtils.isEmpty(list) ? null : list.get(0).getSalesbillNo(), OpsTypeEnum.PUSH_INVOICE.getCode(), ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserName(), opsMessage, list.get(0).getInvoiceNo(), list.get(0).getInvoiceCode());
        }
        return CommonResponse.ok((String)"\u63a8\u9001\u6210\u529f!");
    }

    public boolean cancelInvoiceInfoPDC(List<WkInvoiceEntity> list, String status) {
        InvoiceInfo[] ilist = AssembleTools.syncInvoiceList(list, (String)status);
        InvoiceRQ invoiceRQ = AssembleTools.getInvoiceRQ((InvoiceInfo[])ilist);
        InvoiceRS rs = this.pdcInterfaceImpl.authResultSync(invoiceRQ);
        XtInvoiceEntity invoiceListResult = null;
        ArrayList<XtInvoiceEntity> list2 = new ArrayList<XtInvoiceEntity>();
        JSONObject json = JSONObject.fromObject((Object)((RtnInfo)rs.getRtnInfo().get(0)).getTextMessage());
        String orderCode = json.getString("settlementNo");
        JSONArray jsonArray = json.getJSONArray("params");
        JSONObject jsonO = null;
        for (Object object : jsonArray) {
            jsonO = (JSONObject)object;
            invoiceListResult = new XtInvoiceEntity();
            invoiceListResult.setOrderCode(orderCode);
            invoiceListResult.setBillNumber(jsonO.getString("invoiceNo"));
            invoiceListResult.setNoticeAddStatus(Integer.valueOf(1));
            if (!"0000".equals(jsonO.getString("code"))) {
                invoiceListResult.setNoticeAddStatus(Integer.valueOf(2));
            }
            invoiceListResult.setNoticeAddRemark(jsonO.getString("msg"));
            list2.add(invoiceListResult);
        }
        if ("0".equals(status)) {
            this.xtInvoiceBusiness.updateDeleteSyncServiceSystemResultPDC(list2);
        } else if ("1".equals(status)) {
            this.xtInvoiceBusiness.updateAddSyncXtINvoice(list2, false);
        }
        return true;
    }

    public boolean cancelInvoiceInfoSAP(WkInvoiceEntity invoice, String status) {
        List invoiceResults = AssembleTools.syncInvoiceList((WkInvoiceEntity)invoice, (String)status);
        JSONArray rs = null;
        if ("0".equals(status)) {
            rs = this.sapInterfaceImpl.invoiceStatusResults(invoiceResults);
        } else if ("1".equals(status)) {
            ArrayList sendSapInvoiceList = new ArrayList();
            invoiceResults.stream().forEach(item -> sendSapInvoiceList.add(item));
            this.logger.info("\u63a8\u9001\u5f00\u7968\u4fe1\u606fSAP{}", sendSapInvoiceList);
            rs = this.sapInterfaceImpl.invoiceStatusResults(sendSapInvoiceList);
        }
        JSONObject jsonO = null;
        XtInvoiceEntity invoiceListResult = null;
        ArrayList list2 = Lists.newArrayList();
        for (Object object : rs) {
            jsonO = (JSONObject)object;
            invoiceListResult = new XtInvoiceEntity();
            invoiceListResult.setOrderCode(jsonO.getString("settlementNo"));
            invoiceListResult.setBillNumber(invoice.getInvoiceNo());
            invoiceListResult.setNoticeAddStatus(Integer.valueOf(1));
            invoiceListResult.setBillCode(invoice.getInvoiceCode());
            if (!"S000".equals(jsonO.getString("STATUSCODE"))) {
                invoiceListResult.setNoticeAddStatus(Integer.valueOf(2));
            }
            invoiceListResult.setNoticeAddRemark(jsonO.getString("STATUSMESSAGE"));
            list2.add(invoiceListResult);
        }
        if ("0".equals(status)) {
            List xtInvoiceEntityList;
            int row = this.xtInvoiceBusiness.updateDeleteSyncServiceSystemResultPDC((List)list2);
            if (row > 0 && !CollectionUtils.isEmpty((Collection)(xtInvoiceEntityList = this.xtInvoiceBusiness.getXtInvoiceByCodeNo(((XtInvoiceEntity)list2.get(0)).getBillCode(), ((XtInvoiceEntity)list2.get(0)).getBillNumber())))) {
                QueueSender.textSend((String)"xtInvoiceSyncDealQueue", (String)String.valueOf(((XtInvoiceEntity)xtInvoiceEntityList.get(0)).getId()), (Map)null);
            }
        } else if ("1".equals(status)) {
            this.xtInvoiceBusiness.updateAddSyncXtINvoice((List)list2, false);
        }
        return true;
    }
}

