/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceaudit.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.InvoiceAmountBean;
import com.xforceplus.vanke.in.client.model.InvoiceAuditRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.ModifyRecogBusiness;
import com.xforceplus.vanke.sc.base.enums.Business.CooperateFlagEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.AuthSyncStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.SellerSysStatusEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DeleteImagesProcess
extends AbstractProcess<InvoiceAuditRequest, InvoiceAmountBean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private ModifyRecogBusiness modifyRecogBusiness;

    protected void check(InvoiceAuditRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getInvoiceId(), "\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getOrderCode(), "\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<InvoiceAmountBean> process(InvoiceAuditRequest request) throws RuntimeException {
        boolean success;
        WkInvoiceEntity entity = this.wkInvoiceDao.selectByPrimaryKey(request.getInvoiceId());
        if (null == entity) {
            return CommonResponse.failed((String)"\u67e5\u8be2\u7684\u53d1\u7968\u4e0d\u5b58\u5728");
        }
        if (this.invoiceBusiness.checkRepeatRelation(entity, request.getOrderCode(), null).booleanValue()) {
            return CommonResponse.ok((String)"\u5220\u9664\u6210\u529f", (Object)this.modifyRecogBusiness.getInvoiceAmount(request.getOrderCode()));
        }
        ArrayList list = Lists.newArrayList();
        Integer cooperateFlag = entity.getCooperateFlag();
        if (null != cooperateFlag && CooperateFlagEnum.NO_COOPERATE.getCode().equals(cooperateFlag) && !StringHelp.safeIsEmpty((Object)entity.getSmInvoiceId()) && !StringHelp.safeIsEmpty((Object)entity.getSmInvoiceId()) && !(success = this.modifyRecogBusiness.invoiceUpdateOrDelete(entity, "2"))) {
            return CommonResponse.failed((String)"\u8c03\u7528\u56fd\u4fe1\u63a5\u53e3\u5220\u9664\u5931\u8d25.");
        }
        list.add(entity);
        if (CooperateFlagEnum.NO_COOPERATE.getCode().equals(cooperateFlag)) {
            this.wkInvoiceDao.deleteByExample(this.invoiceBusiness.setWkInvoiceExampleByIds((List)list));
        } else if (CooperateFlagEnum.YES_COORPERATE.getCode().equals(cooperateFlag) && !SellerSysStatusEnum.COMING_SALLER_INFO_XT.getCode().equals(entity.getSellerSyncStatus()) && AuthSyncStatusEnum.DEFAULT_NO.getCode().equals(entity.getAuthSyncStatus())) {
            this.wkInvoiceDao.deleteByExample(this.invoiceBusiness.setWkInvoiceExampleByIds((List)list));
        } else {
            this.wkInvoiceDao.updateByPrimaryKeySelective(this.invoiceBusiness.clearImageInfo(entity.getId(), entity.getAuthSyncStatus(), false, false));
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.invoiceBusiness.deleteRecogInvoice((List)list, null, Integer.valueOf(8), true, null);
            if (!StringHelp.safeIsEmpty((Object)entity.getSalesbillNo())) {
                this.invoiceBusiness.deleteImageForOrderCode(entity.getSalesbillNo(), false);
            }
        }
        return CommonResponse.ok((String)"\u5220\u9664\u6210\u529f", (Object)this.modifyRecogBusiness.getInvoiceAmount(request.getOrderCode()));
    }
}

