/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceaudit.process;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.InvoiceAuditBean;
import com.xforceplus.vanke.in.client.model.InvoiceAuditDtoBean;
import com.xforceplus.vanke.in.client.model.InvoiceAuditRequest;
import com.xforceplus.vanke.in.repository.daoext.InvoiceDaoExt;
import com.xforceplus.vanke.in.repository.daoext.InvoiceDetailsDaoExt;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.orders.OrdersBusiness;
import com.xforceplus.vanke.sc.base.enums.Business.CooperateFlagEnum;
import com.xforceplus.vanke.sc.base.enums.IsOrNo;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.RecogImageStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.StatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.StatusEnum2;
import com.xforceplus.vanke.sc.outer.gx.GXInterfaceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetInvoiceAuditProcess
extends AbstractProcess<InvoiceAuditRequest, InvoiceAuditBean> {
    @Autowired
    private OrdersBusiness ordersBusiness;
    @Autowired
    private InvoiceDetailsDaoExt invoiceDetailsDaoExt;
    @Autowired
    private GXInterfaceImpl gxInterfaceImpl;
    @Autowired
    private InvoiceDaoExt invoiceDaoExt;
    @Autowired
    private InvoiceBusiness invoiceBusiness;

    protected void check(InvoiceAuditRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getOrderCode(), "\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<InvoiceAuditBean> process(InvoiceAuditRequest request) throws RuntimeException {
        InvoiceAuditBean auditBean = new InvoiceAuditBean();
        long start1 = System.currentTimeMillis();
        List ordersList = this.ordersBusiness.selectBySelect(request.getOrderCode(), null);
        if (CollectionUtils.isEmpty((Collection)ordersList)) {
            return CommonResponse.failed((String)"\u67e5\u8be2\u7684\u4e1a\u52a1\u5355\u6570\u636e\u4e0d\u5b58\u5728.");
        }
        long start2 = System.currentTimeMillis();
        System.out.println("\u5ba1\u6838\u9875\u9762\u67e5\u8be21-------------\uff1a" + (start2 - start1));
        WkOrdersEntity ordersEntity = (WkOrdersEntity)ordersList.get(0);
        if (!StatusEnum.NORMAL.getCode().equals(ordersEntity.getStatus())) {
            return CommonResponse.failed((String)"\u4e1a\u52a1\u5355\u53f7\u5df2\u4f5c\u5e9f/\u5220\u9664\uff0c\u8bf7\u68c0\u67e5.");
        }
        auditBean.setOrderCode(ordersEntity.getSalesbillNo());
        auditBean.setPurchaserTaxNo(ordersEntity.getPurchaserTaxNo());
        auditBean.setPurchaserName(ordersEntity.getPurchaserName());
        auditBean.setIsLegalSynergetics(ordersEntity.getIsLegalSynergetics());
        auditBean.setCooperateFlag(ordersEntity.getCooperateFlag());
        auditBean.setAuditStatus(ordersEntity.getAuditStatus());
        auditBean.setAutoCheckStatus(ordersEntity.getAutoCheckStatus());
        auditBean.setAutoCheckNote(ordersEntity.getAutoCheckNote());
        if (InvoiceTypeEnum.SPECIAL.value().equals(ordersEntity.getBusinessOrderType().toLowerCase())) {
            auditBean.setOrderSpecialAmountWithTax(ordersEntity.getAmountWithTax());
            auditBean.setOrderSpecialTaxAmount(ordersEntity.getTaxAmount());
            auditBean.setOrderNormalAmountWithTax(BigDecimal.ZERO);
        } else {
            auditBean.setOrderNormalAmountWithTax(ordersEntity.getAmountWithTax());
            auditBean.setOrderSpecialAmountWithTax(BigDecimal.ZERO);
            auditBean.setOrderSpecialTaxAmount(BigDecimal.ZERO);
        }
        BigDecimal specialAmountWithTax = BigDecimal.ZERO;
        BigDecimal specialTaxAmount = BigDecimal.ZERO;
        BigDecimal normalAmountWithTax = BigDecimal.ZERO;
        ArrayList dtos = Lists.newArrayList();
        ArrayList invoiceList = Lists.newArrayList();
        ArrayList invoiceIds = Lists.newArrayList();
        List tempList1 = this.invoiceBusiness.getInvoiceListForAudit(request.getOrderCode());
        if (!CollectionUtils.isEmpty((Collection)tempList1)) {
            invoiceList.addAll(tempList1);
            invoiceIds.addAll(tempList1.stream().map(r -> r.getId()).collect(Collectors.toList()));
        }
        long start3 = System.currentTimeMillis();
        System.out.println("\u5ba1\u6838\u9875\u9762\u67e5\u8be22-------------\uff1a" + (start3 - start2));
        List tempList2 = this.invoiceDaoExt.getInvoiceListByRelation(request.getOrderCode());
        if (!CollectionUtils.isEmpty((Collection)tempList2)) {
            tempList2 = tempList2.stream().filter(r -> !invoiceIds.contains(r.getId())).collect(Collectors.toList());
            invoiceIds.addAll(tempList2.stream().map(r -> r.getId()).collect(Collectors.toList()));
            invoiceList.addAll(tempList2);
        }
        long start4 = System.currentTimeMillis();
        System.out.println("\u5ba1\u6838\u9875\u9762\u67e5\u8be23-------------\uff1a" + (start4 - start3));
        Map<Object, Object> cargoNameMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)invoiceIds)) {
            List detailsEntityList = this.invoiceDetailsDaoExt.selectCargoNameByInvoiceId((List)invoiceIds);
            cargoNameMap = detailsEntityList.stream().filter(r -> !StringHelp.safeIsEmpty((Object)r.getCargoName())).collect(Collectors.toMap(r -> r.getInvoiceId(), r -> r.getCargoName()));
        }
        long start5 = System.currentTimeMillis();
        System.out.println("\u5ba1\u6838\u9875\u9762\u67e5\u8be24-------------\uff1a" + (start5 - start4));
        for (WkInvoiceEntity entity : invoiceList) {
            String imgUrl;
            InvoiceAuditDtoBean dto = new InvoiceAuditDtoBean();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            if (null != cargoNameMap && cargoNameMap.get(entity.getId()) != null) {
                dto.setCargoName((String)cargoNameMap.get(entity.getId()));
            } else {
                dto.setCargoName("");
            }
            if (IsOrNo.YES.getCode().equals(entity.getIfRepeat())) {
                List salebillNoList = this.invoiceBusiness.checkRepeat(entity, request.getOrderCode(), true);
                dto.setSalesbillList(salebillNoList);
            }
            if (!StringHelp.safeIsEmpty((Object)(imgUrl = this.invoiceBusiness.getInvoiceImgUrl(entity, ordersEntity)))) {
                if (RecogImageStatusEnum.INVOICE.getCode().equals(entity.getRecogImageStatus())) {
                    dto.setRecogInvoiceImageUrl(imgUrl);
                } else if (RecogImageStatusEnum.DEDUCTIBLE.getCode().equals(entity.getRecogImageStatus())) {
                    String imgUrl_dk = this.invoiceBusiness.getInvoiceImgUrl_dk(entity);
                    imgUrl_dk = StringHelp.safeIsEmpty((Object)imgUrl_dk) ? imgUrl : imgUrl_dk;
                    dto.setRecogDeductionImageUrl(imgUrl_dk);
                } else {
                    dto.setRecogInvoiceImageUrl(imgUrl);
                }
            }
            dtos.add(dto);
            if (StatusEnum2.OBSOLETE.getCode().equals(entity.getStatus())) continue;
            if (InvoiceTypeEnum.SPECIAL.value().equals(entity.getInvoiceType())) {
                specialAmountWithTax = specialAmountWithTax.add(entity.getAmountWithTax());
                specialTaxAmount = specialTaxAmount.add(entity.getTaxAmount());
                continue;
            }
            normalAmountWithTax = normalAmountWithTax.add(entity.getAmountWithTax());
        }
        long start6 = System.currentTimeMillis();
        System.out.println("\u5ba1\u6838\u9875\u9762\u67e5\u8be25-------------\uff1a" + (start6 - start5));
        auditBean.setInvoiceSpecialAmountWithTax(specialAmountWithTax);
        auditBean.setInvoiceSpecialTaxAmount(specialTaxAmount);
        auditBean.setInvoiceNormalAmountWithTax(normalAmountWithTax);
        auditBean.setInvoiceNum(Integer.valueOf(invoiceList.size()));
        auditBean.setDetailsBeanList((List)dtos);
        if (CooperateFlagEnum.NO_COOPERATE.getCode().equals(ordersEntity.getCooperateFlag())) {
            try {
                String addImageUrl = this.gxInterfaceImpl.getShowImageUrl(this.invoiceBusiness.setImageServiceInfo(request.getOrderCode(), "8"));
                if ("500".equals(addImageUrl)) {
                    return CommonResponse.failed((String)"\u56fd\u4fe1\u7cfb\u7edf\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u56fd\u4fe1\u8fd0\u7ef4\u4eba\u5458\uff01");
                }
                auditBean.setAddImageUrl(addImageUrl);
                String queryImageUrl = this.gxInterfaceImpl.getShowImageUrl(this.invoiceBusiness.setImageServiceInfo(request.getOrderCode(), "1"));
                if ("500".equals(queryImageUrl)) {
                    return CommonResponse.failed((String)"\u56fd\u4fe1\u7cfb\u7edf\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u56fd\u4fe1\u8fd0\u7ef4\u4eba\u5458\uff01");
                }
                auditBean.setQueryImageUrl(queryImageUrl);
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u56fd\u4fe1\u5f71\u50cf\u5730\u5740\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                return CommonResponse.failed((String)"\u56fd\u4fe1\u7cfb\u7edf\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u56fd\u4fe1\u8fd0\u7ef4\u4eba\u5458\uff01");
            }
        }
        long start7 = System.currentTimeMillis();
        System.out.println("\u5ba1\u6838\u9875\u9762\u67e5\u8be26-------------\uff1a" + (start7 - start6));
        System.out.println("\u5ba1\u6838\u9875\u9762ALL\u67e5\u8be2-------------\uff1a" + (start7 - start1));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)auditBean);
    }
}

