/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceauth.process;

import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.AuthStatisticsDetailBean;
import com.xforceplus.vanke.in.client.model.AuthSummaryRequest;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceSummaryBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.common.AuthSummaryEnum;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthSummaryProcess
extends AbstractProcess<AuthSummaryRequest, List<AuthStatisticsDetailBean>> {
    @Autowired
    private InvoiceSummaryBusiness invoiceSummaryBusiness;

    protected void check(AuthSummaryRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getSummaryType(), "\u6c47\u603b\u7c7b\u578b\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getYearTime(), "\u7edf\u8ba1\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        if (!Constants.NUMBER_ZERO.equals(request.getSummaryType())) {
            this.checkEmpty(request.getCompanyTaxNo(), "\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected CommonResponse<List<AuthStatisticsDetailBean>> process(AuthSummaryRequest request) throws RuntimeException {
        String startTime = Integer.parseInt(request.getYearTime()) - 1 + "12";
        String endTime = request.getYearTime() + "12";
        List summaryList = this.invoiceSummaryBusiness.selectAuthSummay(request.getCompanyTaxNo(), startTime, endTime);
        List companyTaxNoList = summaryList.stream().map(r -> r.getPurchaserTaxNo()).distinct().collect(Collectors.toList());
        List authStatisticDetails = this.invoiceSummaryBusiness.setStatisticRate(summaryList, request.getYearTime(), companyTaxNoList.size(), request.getTaxPeriod());
        if (request.getSummaryType().equals(Constants.NUMBER_ZERO)) {
            String max = DateHelp.getMonth();
            authStatisticDetails = authStatisticDetails.stream().map(r -> {
                if (r.getDeclareTime().compareTo(max) < 0) {
                    r.setItemType(AuthSummaryEnum.DECLARE.getCode());
                } else if (r.getDeclareTime().compareTo(max) == 0) {
                    r.setItemType(AuthSummaryEnum.CURRENT.getCode());
                } else {
                    r.setItemType(AuthSummaryEnum.NO.getCode());
                }
                return r;
            }).collect(Collectors.toList());
        }
        return CommonResponse.ok((String)"\u6210\u529f", (Object)authStatisticDetails);
    }
}

