/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceauth.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.AuthStatisticsDetailBean;
import com.xforceplus.vanke.in.client.model.SendAuthRequest;
import com.xforceplus.vanke.in.client.model.SendAuthStatisticBean;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceAuthBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceAuthEnum;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonEntity;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetAuthInvoiceInfoStatisticProcess
extends AbstractProcess<SendAuthRequest, SendAuthStatisticBean> {
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private InvoiceAuthBusiness invoiceAuthBusiness;

    protected void check(SendAuthRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getAuthTab(), "\u8ba4\u8bc1\u9875\u9762tab\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getInvoiceIds(), "\u53d1\u7968id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<SendAuthStatisticBean> process(SendAuthRequest request) throws RuntimeException {
        SendAuthStatisticBean sendAuthStatisticBean = new SendAuthStatisticBean();
        List invoiceList = this.invoiceBusiness.getInvoiceListByParams(request.getInvoiceIds(), null);
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53d1\u7968\u6570\u636e.");
        }
        Map<String, List<WkInvoiceEntity>> resultMap = invoiceList.stream().collect(Collectors.groupingBy(r -> r.getPurchaserTaxNo()));
        List companyTaxNoList = resultMap.entrySet().stream().map(r -> (String)r.getKey()).collect(Collectors.toList());
        Map periodMap = this.invoiceAuthBusiness.getAuthPeriodMap(companyTaxNoList);
        sendAuthStatisticBean = this.setAuthStatisticData(sendAuthStatisticBean, resultMap, periodMap, request.getAuthTab());
        List authCompanyInfo = this.invoiceAuthBusiness.getAuthStatistInfoByparam(request.getAuthTab(), companyTaxNoList, periodMap);
        sendAuthStatisticBean.setAuthCompanyInfo(authCompanyInfo);
        return CommonResponse.ok((String)"\u6210\u529f", (Object)sendAuthStatisticBean);
    }

    private SendAuthStatisticBean setAuthStatisticData(SendAuthStatisticBean authStatisticObj, Map<String, List<WkInvoiceEntity>> resultMap, Map<String, WkLegalPersonEntity> periodMap, Integer authTab) {
        List unauthCompanyInfo = resultMap.entrySet().stream().map(item -> {
            AuthStatisticsDetailBean authStatisticDetail = new AuthStatisticsDetailBean();
            List entityList = Lists.newArrayList();
            if (null != item.getValue()) {
                entityList = (List)item.getValue();
            }
            if (periodMap.get(item.getKey()) != null) {
                if (InvoiceAuthEnum.EL_AUTH.getCode().equals(authTab)) {
                    authStatisticDetail.setDeclareTime(((WkLegalPersonEntity)periodMap.get(item.getKey())).getPeriodDate());
                }
                authStatisticDetail.setCompanyName(((WkLegalPersonEntity)periodMap.get(item.getKey())).getTaxPayer());
            } else {
                authStatisticDetail.setDeclareTime("");
                authStatisticDetail.setCompanyName("");
            }
            authStatisticDetail.setCompanyTaxNo((String)item.getKey());
            this.invoiceAuthBusiness.addInvoiceTypeData(authStatisticDetail, entityList, authTab);
            return authStatisticDetail;
        }).collect(Collectors.toList());
        authStatisticObj.setUnauthCompanyInfo(unauthCompanyInfo);
        int sInvoiceNum = unauthCompanyInfo.stream().mapToInt(r -> r.getSpInvoiceNum()).sum();
        BigDecimal sAmountWithTax = unauthCompanyInfo.stream().map(r -> r.getSpAmountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sTaxAmount = unauthCompanyInfo.stream().map(r -> r.getSpTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        int ctInvoiceNum = unauthCompanyInfo.stream().mapToInt(r -> r.getCtInvoiceNum()).sum();
        BigDecimal ctAmountWithTax = unauthCompanyInfo.stream().map(r -> r.getCtAmountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ctTaxAmount = unauthCompanyInfo.stream().map(r -> r.getCtTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        int invoiceNum = unauthCompanyInfo.stream().mapToInt(r -> r.getInvoiceNum()).sum();
        BigDecimal amountWithTax = unauthCompanyInfo.stream().map(r -> r.getAmountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmount = unauthCompanyInfo.stream().map(r -> r.getTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        int totalInvoiceNum = unauthCompanyInfo.stream().mapToInt(r -> r.getInvoiceNum()).sum();
        BigDecimal totalAmountWithTax = unauthCompanyInfo.stream().map(r -> r.getAmountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalTaxAmount = unauthCompanyInfo.stream().map(r -> r.getTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (Constants.NUMBER_ONE.equals(authTab)) {
            int jInvoiceNum = unauthCompanyInfo.stream().mapToInt(r -> r.getVpInvoiceNum()).sum();
            BigDecimal jAmountWithTax = unauthCompanyInfo.stream().map(r -> r.getVpAmountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal jTaxAmount = unauthCompanyInfo.stream().map(r -> r.getVpTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            authStatisticObj.setVpInvoiceNum(Integer.valueOf(jInvoiceNum));
            authStatisticObj.setVpAmountWithTax(jAmountWithTax);
            authStatisticObj.setVpTaxAmount(jTaxAmount);
        }
        authStatisticObj.setSpInvoiceNum(Integer.valueOf(sInvoiceNum));
        authStatisticObj.setSpAmountWithTax(sAmountWithTax);
        authStatisticObj.setSpTaxAmount(sTaxAmount);
        authStatisticObj.setCtInvoiceNum(Integer.valueOf(ctInvoiceNum));
        authStatisticObj.setCtAmountWithTax(ctAmountWithTax);
        authStatisticObj.setCtTaxAmount(ctTaxAmount);
        authStatisticObj.setInvoiceNum(Integer.valueOf(invoiceNum));
        authStatisticObj.setAmountWithTax(amountWithTax);
        authStatisticObj.setTaxAmount(taxAmount);
        authStatisticObj.setTotalInvoiceNum(Integer.valueOf(totalInvoiceNum));
        authStatisticObj.setTotalAmountWithTax(totalAmountWithTax);
        authStatisticObj.setTotalTaxAmount(totalTaxAmount);
        return authStatisticObj;
    }
}

