/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceauth.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.SendAuthRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceAuthBusiness;
import com.xforceplus.vanke.sc.base.enums.company.AuthTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.AuthStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.DataFromSystemEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceAuthEnum;
import com.xforceplus.vanke.sc.outer.api.imsApi.eas._164._5._0._10.ormrpc.services.WSEasBXFacade.WSEasBXFacadeSrvProxy;
import com.xforceplus.vanke.sc.outer.api.imsApi.eas._164._5._0._10.ormrpc.services.WSEasBXFacade.WSEasBXFacadeSrvProxyProxy;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonEntity;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SendAuthProcess
extends AbstractProcess<SendAuthRequest, Boolean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private InvoiceAuthBusiness invoiceAuthBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(SendAuthRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getAuthTab(), "\u8ba4\u8bc1\u9875\u9762tab\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getInvoiceIds(), "\u53d1\u7968id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<Boolean> process(SendAuthRequest request) throws RuntimeException {
        WkInvoiceExample example = new WkInvoiceExample();
        WkInvoiceExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn(request.getInvoiceIds());
        criteria.andAuthStatusIn(Arrays.asList(AuthStatusEnum.DEFAULT.getCode(), AuthStatusEnum.CAN_NOT_AUTH.getCode(), AuthStatusEnum.NOT_AUTH.getCode(), AuthStatusEnum.FAILED.getCode(), AuthStatusEnum.IN_AUTH.getCode()));
        List invoiceList = this.wkInvoiceDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53d1\u7968\u6570\u636e.");
        }
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List resultList = Lists.newArrayList();
        if (InvoiceAuthEnum.EL_AUTH.getCode().equals(request.getAuthTab())) {
            resultList = this.invoiceAuthBusiness.packagingElAuthUpload(invoiceList, Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName());
        }
        if (InvoiceAuthEnum.TR_AUTH.getCode().equals(request.getAuthTab())) {
            resultList = this.invoiceAuthBusiness.packagingAuthUpload(invoiceList, Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName());
        }
        if (InvoiceAuthEnum.IN_AUTH.getCode().equals(request.getAuthTab())) {
            List tempList = invoiceList.stream().filter(r -> !StringHelp.safeIsEmpty((Object)r.getPurchaserTaxNo())).map(r -> r.getPurchaserTaxNo()).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tempList)) {
                return CommonResponse.failed((String)"\u52fe\u9009\u7684\u53d1\u7968\u6ca1\u6709\u627e\u5230\u8d2d\u65b9\u7a0e\u53f7\u3002");
            }
            Map periodMap = this.invoiceAuthBusiness.getAuthPeriodMap(tempList);
            ArrayList elTemp = Lists.newArrayList();
            ArrayList trTemp = Lists.newArrayList();
            invoiceList.stream().forEach(r -> {
                Integer authType = -1;
                if (null != periodMap && periodMap.get(r.getPurchaserTaxNo()) != null) {
                    authType = ((WkLegalPersonEntity)periodMap.get(r.getPurchaserTaxNo())).getAuthType();
                }
                if (AuthTypeEnum.ELECTRONIC_ACCOUNT.getCode().equals(authType) || AuthTypeEnum.ALL_OK.getCode().equals(authType)) {
                    elTemp.add(r);
                }
                if (AuthTypeEnum.WEB_AUTHENTICATION.getCode().equals(authType)) {
                    trTemp.add(r);
                }
            });
            if (!CollectionUtils.isEmpty((Collection)elTemp)) {
                resultList.addAll(this.invoiceAuthBusiness.packagingElAuthUpload((List)elTemp, Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName()));
            }
            if (!CollectionUtils.isEmpty((Collection)trTemp)) {
                resultList.addAll(this.invoiceAuthBusiness.packagingAuthUpload((List)trTemp, Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName()));
            }
        }
        try {
            WSEasBXFacadeSrvProxy wSrvProxy = new WSEasBXFacadeSrvProxyProxy().getWSEasBXFacadeSrvProxy();
            for (WkInvoiceEntity wkInvoiceEntity : resultList) {
                String dataFromSystem = wkInvoiceEntity.getDataFromSystem();
                if (!StringHelp.safeIsEmpty((Object)dataFromSystem) && !dataFromSystem.toUpperCase().contains(DataFromSystemEnum.EAS.getCode()) && !dataFromSystem.toUpperCase().contains(DataFromSystemEnum.WY.getCode())) continue;
                String result = wSrvProxy.updateIsCertificating(wkInvoiceEntity.getSalesbillNo(), 1);
                this.logger.info("\u7535\u5b50\u5e95\u8d26/\u52fe\u9009\u786e\u8ba4\u8bf7\u6c42\u4e0a\u4f20EAS ******************* " + result + " - " + wkInvoiceEntity.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("******************* \u7535\u5b50\u5e95\u8d26/\u52fe\u9009\u786e\u8ba4\u8bf7\u6c42\u4e0a\u4f20EAS\u5931\u8d25*******************", (Throwable)e);
            return CommonResponse.failed((String)("\u7535\u5b50\u5e95\u8d26/\u52fe\u9009\u786e\u8ba4\u8bf7\u6c42\u4e0a\u4f20EAS\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return CommonResponse.ok((String)("\u53d1\u9001\u8bf7\u6c42\u6210\u529f\uff0c\u6210\u529f\uff1a" + resultList.size() + "\u6761"));
    }
}

