/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.postcode.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.in.client.model.GetPostcodeOrdersListRequest;
import com.xforceplus.vanke.in.client.model.WkOrdersDTO;
import com.xforceplus.vanke.in.client.model.WkPostcodeOrdersBean;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.dao.WkPostcodeDao;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.in.repository.model.WkPostcodeEntity;
import com.xforceplus.vanke.in.repository.model.WkPostcodeExample;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GetPostcodeOrdersListProcess
extends AbstractProcess<GetPostcodeOrdersListRequest, ListResult<WkPostcodeOrdersBean>> {
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private WkPostcodeDao wkPostcodeDao;

    protected void check(GetPostcodeOrdersListRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<ListResult<WkPostcodeOrdersBean>> process(GetPostcodeOrdersListRequest request) throws RuntimeException {
        WkOrdersExample example = this.createExample(request);
        example.setLimit(request.getRows());
        example.setOffset(request.getOffset());
        List wkPostcodeOrdersBeans = this.wkOrdersDao.selectByExample(example).stream().map(entity -> {
            WkPostcodeOrdersBean bean = new WkPostcodeOrdersBean();
            BeanUtils.copyProperties((Object)entity, (Object)bean);
            return bean;
        }).collect(Collectors.toList());
        this.getPackageCode(wkPostcodeOrdersBeans);
        ListResult listResult = new ListResult(Long.valueOf(this.wkOrdersDao.countByExample(example)), wkPostcodeOrdersBeans);
        return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
    }

    public WkOrdersExample createExample(GetPostcodeOrdersListRequest request) {
        WkOrdersExample example = new WkOrdersExample();
        WkOrdersExample.Criteria criteria = example.createCriteria();
        criteria.andSignStatusGreaterThan(Integer.valueOf(0));
        if (!StringUtils.isEmpty((Object)request.getPackageCode())) {
            criteria.andPackageCodeLike(request.getPackageCode().trim() + "%");
        }
        if (!StringUtils.isEmpty((Object)request.getSalesbillNo())) {
            criteria.andSalesbillNoEqualTo(request.getSalesbillNo());
        }
        if (request.getSignStatus() != null) {
            criteria.andSignStatusEqualTo(request.getSignStatus());
        }
        if (!CollectionUtils.isEmpty((Collection)request.getSignFailType())) {
            criteria.andSignFailTypeIn(request.getSignFailType());
        }
        if (!CollectionUtils.isEmpty((Collection)request.getRecieveTime()) && request.getRecieveTime().size() == 2) {
            criteria.andSignTimeBetween(new Date((Long)request.getRecieveTime().get(0)), new Date((Long)request.getRecieveTime().get(1)));
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getSignPerson())) {
            criteria.andSignPersonIn(request.getSignPerson());
        }
        example.setOrderByClause("sign_time desc");
        return example;
    }

    public void getPackageCode(List<WkPostcodeOrdersBean> wkPostcodeOrdersBeans) {
        List packageCodes = wkPostcodeOrdersBeans.stream().filter(entity -> !StringHelp.safeIsEmpty((Object)entity.getPackageCode())).map(WkOrdersDTO::getPackageCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(packageCodes)) {
            return;
        }
        WkPostcodeExample wkPostcodeExample = new WkPostcodeExample();
        wkPostcodeExample.createCriteria().andPackageCodeIn(packageCodes);
        List postcodeEntities = this.wkPostcodeDao.selectByExample(wkPostcodeExample);
        if (CollectionUtils.isEmpty((Collection)postcodeEntities)) {
            return;
        }
        Map packageCodeMap = postcodeEntities.stream().collect(Collectors.toMap(WkPostcodeEntity::getPackageCode, Function.identity()));
        wkPostcodeOrdersBeans.forEach(bean -> {
            if (packageCodeMap.containsKey(bean.getPackageCode())) {
                WkPostcodeEntity postcodeEntity = (WkPostcodeEntity)packageCodeMap.get(bean.getPackageCode());
                bean.setPostRecieveTime(postcodeEntity.getRecieveTime());
                bean.setPostReciever(postcodeEntity.getReciever());
            }
        });
    }
}

