/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.smfile.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BatchRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.repository.dao.SmFileDao;
import com.xforceplus.vanke.in.repository.dao.SmFileInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.SmInvoiceDao;
import com.xforceplus.vanke.in.repository.model.SmFileEntity;
import com.xforceplus.vanke.in.repository.model.SmFileExample;
import com.xforceplus.vanke.in.repository.model.SmFileInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.SmFileInvoiceExample;
import com.xforceplus.vanke.in.repository.model.SmInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.SmInvoiceExample;
import com.xforceplus.vanke.in.service.smfile.SmFileInvoiceBusiness;
import com.xforceplus.vanke.sc.base.enums.IsOrNo;
import com.xforceplus.vanke.sc.base.enums.sm_file.BizTypeEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.RecStatusEnum;
import com.xforceplus.xplatdata.base.BaseEntity;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BatchBackSmFileHistoryProcess
extends AbstractProcess<BatchRequest<Long>, Boolean> {
    @Autowired
    private SmFileDao smFileDao;
    @Autowired
    private SmInvoiceDao smInvoiceDao;
    @Autowired
    private SmFileInvoiceDao smFileInvoiceDao;
    @Autowired
    private SmFileInvoiceBusiness smFileInvoiceBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Boolean> process(BatchRequest<Long> request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (!this.smFileInvoiceBusiness.tryLockByUserId(Long.valueOf(userSessionInfo.getAccountId()))) {
            return CommonResponse.failed((String)"\u4e1a\u52a1\u7e41\u5fd9\u8bf7\u91cd\u8bd5");
        }
        try {
            SmFileInvoiceExample example = new SmFileInvoiceExample();
            SmFileInvoiceExample.Criteria criteria = example.createCriteria();
            criteria.andCreateUserIdEqualTo(Long.valueOf(userSessionInfo.getAccountId()));
            long count = this.smFileInvoiceDao.countByExample(example);
            if (count + (long)request.getKeys().size() > 600L) {
                CommonResponse commonResponse = CommonResponse.failed((String)"\u5f85\u63d0\u4ea4\u5df2\u8fbe\u4e0a\u9650\u3010600\u3011\uff0c\u8bf7\u63d0\u4ea4\u540e\u518d\u9000\u626b");
                return commonResponse;
            }
            SmFileExample smFileExample = new SmFileExample();
            smFileExample.createCriteria().andCreateUserIdEqualTo(Long.valueOf(userSessionInfo.getAccountId())).andIdIn(request.getKeys());
            List files = this.smFileDao.selectByExample(smFileExample);
            if (files.size() != request.getKeys().size()) {
                CommonResponse commonResponse = CommonResponse.failed((String)"\u90e8\u5206\u9000\u626b\u6570\u636e\u4e0d\u5b58\u5728");
                return commonResponse;
            }
            if (files.stream().anyMatch(file -> IsOrNo.YES.getCode().equals(file.getIsBackScan()))) {
                CommonResponse commonResponse = CommonResponse.failed((String)"\u6240\u9009\u6587\u4ef6\u5df2\u9000\u626b\uff0c\u4e0d\u80fd\u518d\u6b21\u9000\u626b");
                return commonResponse;
            }
            List fileIds = files.stream().filter(file -> BizTypeEnum.INVOICE.getCode().equals(file.getBizType())).map(BaseEntity::getId).collect(Collectors.toList());
            Map<Object, Object> fileInvoices = new HashMap(fileIds.size());
            if (!fileIds.isEmpty()) {
                SmInvoiceExample smInvoiceExample = new SmInvoiceExample();
                smInvoiceExample.createCriteria().andFileIdIn(fileIds);
                fileInvoices = this.smInvoiceDao.selectByExample(smInvoiceExample).stream().collect(Collectors.toMap(SmInvoiceEntity::getFileId, Function.identity()));
            }
            for (SmFileEntity file2 : files) {
                SmFileInvoiceEntity entity = new SmFileInvoiceEntity();
                BeanUtils.copyProperties((Object)file2, (Object)entity);
                file2.setIsBackScan(IsOrNo.YES.getCode());
                this.smFileDao.updateByPrimaryKeySelective(file2);
                SmInvoiceEntity invoice = (SmInvoiceEntity)fileInvoices.get(file2.getId());
                if (invoice != null) {
                    BeanUtils.copyProperties((Object)invoice, (Object)entity);
                    invoice.setIsBackScan(IsOrNo.YES.getCode());
                    this.smInvoiceDao.updateByPrimaryKeySelective(invoice);
                }
                entity.setRecStatus(RecStatusEnum.FINISH_REC.getCode());
                entity.setCreateUserId(Long.valueOf(userSessionInfo.getAccountId()));
                entity.setCreateUser(userSessionInfo.getSysUserName());
                entity.setCreateTime(new Date());
                entity.setFileOrder(Integer.valueOf((int)(++count)));
                this.smFileInvoiceDao.insertSelective(entity);
            }
            example.setOrderByClause("fileOrder");
            List entities = this.smFileInvoiceDao.selectByExample(example);
            this.smFileInvoiceBusiness.interceptInvoice(entities);
            this.smFileInvoiceBusiness.warningInvoice(entities);
            this.smFileInvoiceBusiness.resetLevel(entities);
            CommonResponse commonResponse = CommonResponse.ok((String)"\u9000\u626b\u6210\u529f", (Object)true);
            return commonResponse;
        }
        finally {
            this.smFileInvoiceBusiness.releaseLockByUserId(Long.valueOf(userSessionInfo.getAccountId()));
        }
    }
}

