/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.smfile.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.BatchUpdateSmFileRequest;
import com.xforceplus.vanke.in.repository.dao.SmFileInvoiceDao;
import com.xforceplus.vanke.in.repository.model.SmFileInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.SmFileInvoiceExample;
import com.xforceplus.vanke.in.service.smfile.SmFileInvoiceBusiness;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceTypeEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.BizTypeEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.InvoiceSheetEnum;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BatchUpdateSmFileProcess
extends AbstractProcess<BatchUpdateSmFileRequest, Boolean> {
    @Autowired
    private SmFileInvoiceDao smFileInvoiceDao;
    @Autowired
    private SmFileInvoiceBusiness smFileInvoiceBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(BatchUpdateSmFileRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getEntities(), "\u66f4\u65b0\u7684\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        request.getEntities().forEach(entity -> {
            this.checkEmpty((Object)entity.getId(), "Id\u4e0d\u80fd\u4e3a\u7a7a");
            if (BizTypeEnum.INVOICE.getCode().equals(entity.getBizType()) && ValidatorUtil.isEmpty((String)entity.getSellerTaxNo()) && ValidatorUtil.isEmpty((String)entity.getPurchaserTaxNo())) {
                throw new ValidationException("\u9500\u65b9\u7a0e\u53f7\u548c\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Boolean> process(BatchUpdateSmFileRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (!this.smFileInvoiceBusiness.tryLockByUserId(Long.valueOf(userSessionInfo.getAccountId()))) {
            return CommonResponse.failed((String)"\u4e1a\u52a1\u7e41\u5fd9\u8bf7\u91cd\u8bd5");
        }
        try {
            List entities = request.getEntities().stream().map(dto -> {
                SmFileInvoiceEntity entity = new SmFileInvoiceEntity();
                BeanUtils.copyProperties((Object)dto, (Object)entity);
                entity.setFileOrder(null);
                entity.setFileLevel(null);
                entity.setBillSeq(null);
                entity.setInvoiceSeq(null);
                entity.setAttachmentSeq(null);
                switch (entity.getInvoiceType()) {
                    case "s1": {
                        entity.setInvoiceType(InvoiceTypeEnum.SPECIAL.value());
                        entity.setInvoiceSheet(InvoiceSheetEnum.INVOICE.getCode());
                        break;
                    }
                    case "s2": {
                        entity.setInvoiceType(InvoiceTypeEnum.SPECIAL.value());
                        entity.setInvoiceSheet(InvoiceSheetEnum.DEDUCTIBLE.getCode());
                    }
                }
                entity.setUpdateUserId(Long.valueOf(userSessionInfo.getAccountId()));
                entity.setUpdateTime(new Date());
                return entity;
            }).collect(Collectors.toList());
            entities.forEach(entity -> this.smFileInvoiceDao.updateByPrimaryKeySelective(entity));
            SmFileInvoiceExample example = new SmFileInvoiceExample();
            example.createCriteria().andCreateUserIdEqualTo(Long.valueOf(userSessionInfo.getAccountId()));
            example.setOrderByClause("fileOrder");
            entities = this.smFileInvoiceDao.selectByExample(example);
            this.smFileInvoiceBusiness.interceptInvoice(entities);
            this.smFileInvoiceBusiness.warningInvoice(entities);
            this.smFileInvoiceBusiness.resetLevel(entities);
            CommonResponse commonResponse = CommonResponse.ok((String)"\u66f4\u65b0\u6210\u529f", (Object)true);
            return commonResponse;
        }
        finally {
            this.smFileInvoiceBusiness.releaseLockByUserId(Long.valueOf(userSessionInfo.getAccountId()));
        }
    }
}

