/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.smfile.process;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.repository.dao.SmFileDao;
import com.xforceplus.vanke.in.repository.dao.SmFileInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.SmInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.SmFileEntity;
import com.xforceplus.vanke.in.repository.model.SmFileInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.SmFileInvoiceExample;
import com.xforceplus.vanke.in.repository.model.SmInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.sc.base.enums.Business.CooperateFlagEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.DataFromSystemEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.RecogImageStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.RecogStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.SMInvoiceSourceEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.BizTypeEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.InvoiceSheetEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.RecStatusEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.RequireOcrFlagEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.SubmittedFlagEnum;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonEntity;
import com.xforceplus.vanke.sc.service.LegalPersonBusiness;
import com.xforceplus.vanke.sc.utils.QueueSender;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubmitSmFileProcess
extends AbstractProcess<BaseRequest, Boolean> {
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private SmFileInvoiceDao smFileInvoiceDao;
    @Autowired
    private LegalPersonBusiness legalPersonBusiness;
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private SmFileDao smFileDao;
    @Autowired
    private SmInvoiceDao smInvoiceDao;
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private QueueSender queueSender;

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Boolean> process(BaseRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        SmFileInvoiceExample example = new SmFileInvoiceExample();
        example.createCriteria().andCreateUserIdEqualTo(Long.valueOf(userSessionInfo.getAccountId()));
        example.setOrderByClause("fileOrder");
        List entities = this.smFileInvoiceDao.selectByExample(example);
        if (entities.isEmpty()) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u5f85\u63d0\u4ea4\u5f71\u50cf");
        }
        boolean noSubmit = entities.stream().anyMatch(entity -> RequireOcrFlagEnum.NEED.getCode().equals(entity.getRequireOcrFlag()) && !RecStatusEnum.FINISH_REC.getCode().equals(entity.getRecStatus()));
        if (noSubmit) {
            return CommonResponse.failed((String)"\u5f53\u524d\u6587\u4ef6\u6682\u672a\u8bc6\u522b\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u518d\u63d0\u4ea4");
        }
        List purchaserTaxNos = entities.stream().filter(entity -> BizTypeEnum.INVOICE.getCode().equals(entity.getBizType())).filter(entity -> ValidatorUtil.isNotEmpty((String)entity.getPurchaserTaxNo())).map(SmFileInvoiceEntity::getPurchaserTaxNo).distinct().collect(Collectors.toList());
        if (ValidatorUtil.isNotEmpty(purchaserTaxNos)) {
            List legalPersonRelTaxs = this.legalPersonBusiness.getLegalPersonList(purchaserTaxNos).stream().map(WkLegalPersonEntity::getRelTax).collect(Collectors.toList());
            boolean bl = noSubmit = !purchaserTaxNos.isEmpty() && legalPersonRelTaxs.size() != purchaserTaxNos.size();
            if (noSubmit) {
                List noExistTaxNos = purchaserTaxNos.stream().filter(taxNo -> !legalPersonRelTaxs.contains(taxNo)).collect(Collectors.toList());
                String taxNoStr = StringUtils.join(noExistTaxNos, (String)"\u3001");
                return CommonResponse.from((Integer)9, (String)String.format("\u8d2d\u65b9\u516c\u53f8\u4e0d\u5728\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u8d2d\u65b9\u7a0e\u53f7\u662f\u5426\u6b63\u786e\uff0c\u6216\u68c0\u67e5\u4f01\u4e1a\u4e3b\u6570\u636e\u662f\u5426\u5b58\u5728\uff0c\u5305\u542b\u7a0e\u53f7\uff1a\u3010%s\u3011", taxNoStr));
            }
        }
        HashSet repeatinvoices = new HashSet();
        entities.stream().filter(entity -> BizTypeEnum.INVOICE.getCode().equals(entity.getBizType())).forEach(entity -> {
            WkInvoiceEntity invoice = this.invoiceBusiness.getInvoiceByCodeNo(entity.getBillCode(), entity.getBillNumber());
            if (invoice != null && RecogStatusEnum.RECOG_OK.getCode().equals(invoice.getRecogStatus())) {
                if (InvoiceSheetEnum.DEDUCTIBLE.getCode().equals(entity.getInvoiceSheet()) && (RecogImageStatusEnum.DEDUCTIBLE.getCode().equals(invoice.getRecogImageStatus()) || RecogImageStatusEnum.BOTH.getCode().equals(invoice.getRecogImageStatus()))) {
                    repeatinvoices.add(String.format("%s-%s", entity.getBillCode(), entity.getBillNumber()));
                } else if (RecogImageStatusEnum.INVOICE.getCode().equals(invoice.getRecogImageStatus()) || RecogImageStatusEnum.BOTH.getCode().equals(invoice.getRecogImageStatus())) {
                    repeatinvoices.add(String.format("%s-%s", entity.getBillCode(), entity.getBillNumber()));
                }
            }
        });
        if (repeatinvoices.size() > 0) {
            return CommonResponse.from((Integer)9, (String)String.format("\u53d1\u7968\u5f71\u50cf\u5df2\u4e0a\u4f20\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff0c\u91cd\u590d\u53d1\u7968\uff1a\u3010%s\u3011", StringUtils.join(repeatinvoices, (String)"\u3001")));
        }
        this.saveFileAndInvoice(entities);
        this.smFileInvoiceDao.deleteByExample(example);
        return CommonResponse.ok((String)"\u63d0\u4ea4\u6210\u529f", (Object)true);
    }

    private void saveFileAndInvoice(List<SmFileInvoiceEntity> entities) {
        Long[] parentIds = new Long[]{1L, 0L, 0L, -1L};
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        for (int i = 0; i < entities.size(); ++i) {
            SmFileInvoiceEntity entity = entities.get(i);
            SmFileEntity smFileEntity = new SmFileEntity();
            BeanUtils.copyProperties((Object)entity, (Object)smFileEntity);
            smFileEntity.setSubmittedFlag(SubmittedFlagEnum.FINISH_SUBMIT.getCode());
            smFileEntity.setSubmitTime(new Date());
            if (entity.getFileLevel() == 1 && !invoiceIds.isEmpty()) {
                HashMap propertys = Maps.newHashMap();
                propertys.put("isGxInterface", "0");
                propertys.put("isModify", "0");
                QueueSender.textSend((String)"scanInvoiceSyncDealQueue", (String)JSON.toJSONString(invoiceIds), (Map)propertys);
                invoiceIds.clear();
            }
            smFileEntity.setParentId(parentIds[entity.getFileLevel() - 1]);
            this.smFileDao.insertSelective(smFileEntity);
            parentIds[entity.getFileLevel().intValue()] = smFileEntity.getId();
            if (!BizTypeEnum.INVOICE.getCode().equals(entity.getBizType())) continue;
            SmInvoiceEntity smInvoiceEntity = new SmInvoiceEntity();
            BeanUtils.copyProperties((Object)entity, (Object)smInvoiceEntity);
            if (entity.getWarningInfo().contains("\u53d1\u7968\u4e3a\u975e\u534f\u540c\u4e1a\u52a1")) {
                smInvoiceEntity.setCooperateFlag(CooperateFlagEnum.NO_COOPERATE.getCode());
            } else {
                smInvoiceEntity.setCooperateFlag(CooperateFlagEnum.YES_COORPERATE.getCode());
            }
            smInvoiceEntity.setFileId(smFileEntity.getId());
            smInvoiceEntity.setInvoiceSource(SMInvoiceSourceEnum.SCANNER.getCode());
            smInvoiceEntity.setSourceSystem(DataFromSystemEnum.XYJ.getCode());
            this.smInvoiceDao.insertSelective(smInvoiceEntity);
            invoiceIds.add(smInvoiceEntity.getId());
        }
        if (!invoiceIds.isEmpty()) {
            HashMap propertys = Maps.newHashMap();
            propertys.put("isGxInterface", "0");
            propertys.put("isModify", "0");
            QueueSender.textSend((String)"scanInvoiceSyncDealQueue", (String)JSON.toJSONString(invoiceIds), (Map)propertys);
        }
    }
}

