/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.config;

import com.alibaba.fastjson.support.spring.GenericFastJsonRedisSerializer;
import io.jsonwebtoken.lang.Collections;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@EnableCaching
public class RedisCacheConfig {
    @Value(value="#{${customCache:}}")
    private Map<String, Long> customCache;

    @Bean
    public CacheManager cacheManager(@Qualifier(value="jedisConnectionFactory") RedisConnectionFactory connectionFactory) {
        RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(5L)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericFastJsonRedisSerializer()));
        RedisCacheManager.RedisCacheManagerBuilder builder = RedisCacheManager.builder((RedisConnectionFactory)connectionFactory).cacheDefaults(defaultCacheConfig);
        if (!Collections.isEmpty((Map)this.customCache)) {
            HashMap customCaches = new HashMap(this.customCache.size());
            this.customCache.entrySet().forEach(entry -> customCaches.put(entry.getKey(), defaultCacheConfig.entryTtl(Duration.ofSeconds((Long)entry.getValue()))));
            builder.initialCacheNames(customCaches.keySet()).withInitialCacheConfigurations(customCaches);
        }
        return builder.build();
    }
}

