/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.exception.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.BatchUpdateExceptionRequest;
import com.xforceplus.vanke.in.controller.exception.process.BatchUpdateExceptionProcess;
import com.xforceplus.vanke.in.repository.dao.WkExceptionDao;
import com.xforceplus.vanke.in.repository.model.WkExceptionEntity;
import com.xforceplus.vanke.in.repository.model.WkExceptionExample;
import com.xforceplus.vanke.in.service.exception.ExceptionBusiness;
import com.xforceplus.vanke.sc.base.enums.DocumentTypeEnum;
import com.xforceplus.vanke.sc.base.enums.Exception.HandleStatusEnum;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchUpdateExceptionProcess
extends AbstractProcess<BatchUpdateExceptionRequest, Boolean> {
    @Autowired
    private WkExceptionDao wkExceptionDao;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private ExceptionBusiness exceptionBusiness;

    protected void check(BatchUpdateExceptionRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getEntities(), "\u66f4\u65b0\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        request.getEntities().forEach(dto -> {
            this.checkEmpty((Object)dto.getId(), "\u5f02\u5e38id\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)dto.getHandleStatus(), "\u5904\u7406\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            block0 : switch (1.$SwitchMap$com$xforceplus$vanke$sc$base$enums$Exception$HandleStatusEnum[HandleStatusEnum.fromCode((Integer)dto.getHandleStatus()).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.checkEmpty((Object)dto.getHandleWay(), "\u5904\u7406\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                    this.checkEmpty((Object)dto.getDocumentType(), "\u6587\u6863\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    switch (1.$SwitchMap$com$xforceplus$vanke$sc$base$enums$DocumentTypeEnum[DocumentTypeEnum.fromCode((Integer)dto.getDocumentType()).ordinal()]) {
                        case 1: {
                            break block0;
                        }
                        case 2: {
                            this.checkEmpty(dto.getBillCode(), "\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                            this.checkEmpty(dto.getBillNumber(), "\u53d1\u7968\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                        case 4: {
                            throw new ValidationException("\u672a\u77e5\u7684\u6587\u6863\u7c7b\u578b");
                        }
                    }
                    break;
                }
                default: {
                    throw new ValidationException("\u672a\u77e5\u7684\u5904\u7406\u72b6\u6001");
                }
            }
        });
    }

    protected CommonResponse<Boolean> process(BatchUpdateExceptionRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        ArrayList failOrderCodes = new ArrayList();
        List ids = request.getEntities().stream().map(dto -> {
            WkExceptionEntity entity = new WkExceptionEntity();
            BeanUtils.copyProperties((Object)dto, (Object)entity);
            entity.setHandlePerson(userSessionInfo.getSysUserName());
            entity.setHandleTime(new Date());
            if (HandleStatusEnum.HANG.getCode().equals(dto.getHandleStatus())) {
                entity.setHoldTime(new Date());
            }
            if (this.wkExceptionDao.updateByPrimaryKeySelective(entity) == 0) {
                failOrderCodes.add(entity.getOrderCode());
                return null;
            }
            return entity.getId();
        }).filter(result -> result != null).collect(Collectors.toList());
        if (ids.size() == 0) {
            return CommonResponse.failed((String)"\u5168\u90e8\u5904\u7406\u5931\u8d25");
        }
        WkExceptionExample example = new WkExceptionExample();
        example.createCriteria().andIdIn(ids);
        List entities = this.wkExceptionDao.selectByExample(example);
        this.exceptionBusiness.handleException(entities, userSessionInfo);
        if (failOrderCodes.size() > 0) {
            return CommonResponse.failed((String)String.format("\u4e1a\u52a1\u5355\u3010%s\u3011\u5904\u7406\u5931\u8d25", StringUtils.join(failOrderCodes, (String)"/")));
        }
        return CommonResponse.ok((String)"\u6279\u91cf\u5904\u7406\u6210\u529f", (Object)true);
    }
}

