/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.AdjustInvoiceRelationRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkOrderInvoiceRelationDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.repository.model.WkOrderInvoiceRelationExample;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.sync.tools.InvoiceSyncMainTools;
import com.xforceplus.vanke.in.service.orders.OrdersBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.Business.CooperateFlagEnum;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.base.enums.IsOrNo;
import com.xforceplus.vanke.sc.base.enums.invoice.StatusEnum;
import com.xforceplus.vanke.sc.base.enums.orders.OrderAuditStatusEnum;
import com.xforceplus.vanke.sc.base.enums.orders.OrderReceiveStatusEnum;
import com.xforceplus.vanke.sc.repository.model.SysConfigEntity;
import com.xforceplus.vanke.sc.service.ConfigBusiness;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AdjustInvoiceRelationProcess
extends AbstractProcess<AdjustInvoiceRelationRequest, Boolean> {
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private OrdersBusiness ordersBusiness;
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private WkOrderInvoiceRelationDao wkOrderInvoiceRelationDao;
    @Autowired
    private InvoiceSyncMainTools invoiceSyncMainTools;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ConfigBusiness configBusiness;

    protected void check(AdjustInvoiceRelationRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getInvoiceIds(), "\u53d1\u7968ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getNewSalesbillNo(), "\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Boolean> process(AdjustInvoiceRelationRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List invoiceEntities = this.invoiceBusiness.getInvoiceListByParams(request.getInvoiceIds(), null);
        if (CollectionUtils.isEmpty((Collection)invoiceEntities)) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u627e\u5230\u53ef\u64cd\u4f5c\u7684\u53d1\u7968.");
        }
        if ("delete".equals(request.getNewSalesbillNo())) {
            SysConfigEntity configEntity = this.configBusiness.getButtonPremiss("deleteInvoiceInfo");
            if (null == configEntity) {
                return CommonResponse.failed((String)"\u6ca1\u6709\u64cd\u4f5c\u5220\u9664\u53d1\u7968\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5.");
            }
            if (!configEntity.getConfigValue().contains(String.valueOf(userSessionInfo.getSysUserId()))) {
                return CommonResponse.failed((String)"\u6ca1\u6709\u64cd\u4f5c\u5220\u9664\u53d1\u7968\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5.");
            }
            this.deleteInvoiceInfo(request.getInvoiceIds(), invoiceEntities, userSessionInfo.getSysUserName());
            return CommonResponse.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        WkOrdersEntity ordersEntity = this.ordersBusiness.getOrdersBySalesBillNo(request.getNewSalesbillNo());
        HashMap tempMap = Maps.newHashMap();
        HashMap invoiceMap = Maps.newHashMap();
        invoiceEntities.stream().forEach(r -> {
            List itemList = Lists.newArrayList();
            if (tempMap.containsKey(r.getId())) {
                itemList = (List)tempMap.get(r.getId());
            }
            if (!StringHelp.safeIsEmpty((Object)r.getSalesbillNo())) {
                itemList.add(r.getSalesbillNo());
            }
            tempMap.put(r.getId(), itemList);
            invoiceMap.put(r.getId(), r);
            this.wkInvoiceDao.updateByPrimaryKeySelective(this.setUpdateInfo(r, request.getNewSalesbillNo(), ordersEntity));
        });
        List tempList = this.deleteRelation((Map)tempMap, (Map)invoiceMap, request.getNewSalesbillNo(), request.getInvoiceIds(), userSessionInfo.getSysUserName());
        if (!CollectionUtils.isEmpty((Collection)tempList)) {
            tempList.stream().forEach(r -> this.invoiceSyncMainTools.checkOrderAuthTime(r));
        }
        return CommonResponse.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    private WkInvoiceEntity setUpdateInfo(WkInvoiceEntity sourceEntity, String newSalesbillNo, WkOrdersEntity ordersEntity) {
        WkInvoiceEntity entity = new WkInvoiceEntity();
        entity.setId(sourceEntity.getId());
        entity.setSalesbillNo(newSalesbillNo);
        if (null != ordersEntity && StatusEnum.NORMAL.getCode().equals(ordersEntity.getStatus())) {
            entity.setSalesbillId(ordersEntity.getId());
            entity.setPackageCode(ordersEntity.getPackageCode());
            entity.setSignStatus(ordersEntity.getSignStatus());
            entity.setSignTime(ordersEntity.getSignTime());
            entity.setCooperateFlag(ordersEntity.getCooperateFlag());
            entity.setIfAuthFlag(ordersEntity.getIfAuthFlag());
            entity.setIsLegalSynergetics(ordersEntity.getIsLegalSynergetics());
            entity.setAuditStatus(ordersEntity.getAuditStatus());
            entity.setAuditUpdateTime(ordersEntity.getAuditUpdateTime());
            entity.setAuditUser(ordersEntity.getAuditUser());
        } else {
            entity.setSalesbillId(Constants.LONG_ZERO);
            entity.setPackageCode("");
            entity.setSignStatus(OrderReceiveStatusEnum.DEFAULT.getCode());
            entity.setSignTime(new Date(Constants.DEFAULT_TIME));
            entity.setCooperateFlag(CooperateFlagEnum.NO_COOPERATE.getCode());
            entity.setIfAuthFlag(IsOrNo.NO.getCode());
            entity.setIsLegalSynergetics(IsOrNo.NO.getCode());
            entity.setAuditStatus(OrderAuditStatusEnum.NOT_AUDIT.getCode());
            entity.setAuditUpdateTime(new Date(Constants.DEFAULT_TIME));
            entity.setAuditUser("");
        }
        entity.setIfRepeat(IsOrNo.NO.getCode());
        return entity;
    }

    private void deleteInvoiceInfo(List<Long> ids, List<WkInvoiceEntity> invoiceEntities, String userName) {
        WkInvoiceExample wkInvoiceExample = new WkInvoiceExample();
        wkInvoiceExample.createCriteria().andIdIn(ids);
        WkInvoiceEntity wkInvoiceEntity = new WkInvoiceEntity();
        wkInvoiceEntity.setStatus(Integer.valueOf(9));
        this.wkInvoiceDao.updateByExampleSelective(wkInvoiceEntity, wkInvoiceExample);
        invoiceEntities.stream().forEach(x -> this.logOperationsBusiness.saveLogOperations(x.getSalesbillNo(), OpsTypeEnum.DELETE_INVOICE_INFO.getCode(), userName, OpsTypeEnum.DELETE_INVOICE_INFO.getName(), x.getInvoiceNo(), x.getInvoiceCode()));
    }

    private List<String> deleteRelation(Map<Long, List<String>> salesbillNoMap, Map<Long, WkInvoiceEntity> invoiceMap, String newSalesbillNo, List<Long> invoiceIds, String username) {
        ArrayList resultList = Lists.newArrayList();
        resultList.add(newSalesbillNo);
        WkOrderInvoiceRelationExample example = new WkOrderInvoiceRelationExample();
        WkOrderInvoiceRelationExample.Criteria criteria = example.createCriteria();
        criteria.andInvoiceIdIn(invoiceIds);
        List relationEntities = this.wkOrderInvoiceRelationDao.selectByExample(example);
        if (!CollectionUtils.isEmpty((Collection)relationEntities)) {
            relationEntities.stream().forEach(r -> {
                if (salesbillNoMap.containsKey(r.getInvoiceId())) {
                    List tempList = (List)salesbillNoMap.get(r.getInvoiceId());
                    tempList.add(r.getSalesbillNo());
                    salesbillNoMap.put(r.getInvoiceId(), tempList.stream().distinct().collect(Collectors.toList()));
                }
            });
            this.wkOrderInvoiceRelationDao.deleteByExample(example);
        }
        salesbillNoMap.entrySet().stream().forEach(r -> {
            WkInvoiceEntity entity = (WkInvoiceEntity)invoiceMap.get(r.getKey());
            this.logger.info("\u53d1\u7968\u53f7\u7801\u3010" + entity.getInvoiceNo() + "\u3011\uff0c\u4ee3\u7801\u3010" + entity.getInvoiceCode() + "\u3011\u7531\u539f\u4e1a\u52a1\u5355\u53f7\u3010" + ((List)r.getValue()).stream().collect(Collectors.joining(",")) + "\u3011\u6302\u63a5\u5230\u65b0\u4e1a\u52a1\u5355\u53f7\u3010" + newSalesbillNo + "\u3011");
            this.logOperationsBusiness.saveLogOperations(newSalesbillNo, OpsTypeEnum.ADJUST_INVOICE_RELATION.getCode(), username, "\u53d1\u7968\u53f7\u7801\u3010" + entity.getInvoiceNo() + "\u3011\uff0c\u4ee3\u7801\u3010" + entity.getInvoiceCode() + "\u3011\u7531\u539f\u4e1a\u52a1\u5355\u53f7\u3010" + ((List)r.getValue()).stream().collect(Collectors.joining(",")) + "\u3011\u6302\u63a5\u5230\u65b0\u4e1a\u52a1\u5355\u53f7\u3010" + newSalesbillNo + "\u3011", entity.getInvoiceNo(), entity.getInvoiceCode());
            resultList.addAll((Collection)r.getValue());
        });
        return resultList.stream().distinct().collect(Collectors.toList());
    }
}

