/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.xforceplus.landedestate.basecommon.help.lang.DateConvert;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.vanke.in.client.model.DownloadInvoiceImagesRequest;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceExportBusiness;
import com.xforceplus.vanke.sc.base.enums.Message.MessageTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.ExportTypeEnum;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DownloadInvoiceImagesProcess
extends AbstractProcess<DownloadInvoiceImagesRequest, Integer> {
    @Autowired
    private InvoiceExportBusiness invoiceExportBusiness;
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private MessageBusiness messageBusiness;

    protected void check(DownloadInvoiceImagesRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getInvoiceIds(), "\u53d1\u7968ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty((Object)request.getDownloadType(), "\u4e0b\u8f7d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (!ExportTypeEnum.INVOICE.getCode().equals(request.getDownloadType()) && !ExportTypeEnum.AUTH.getCode().equals(request.getDownloadType())) {
            throw new ValidationException("\u4e0b\u8f7d\u7c7b\u578b\u4e0d\u5408\u6cd5\uff1a1-\u8fdb\u9879\u53d1\u7968\u6c60\uff0c2-\u53d1\u7968\u8ba4\u8bc1");
        }
    }

    protected CommonResponse<Integer> process(DownloadInvoiceImagesRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String downloadName = ExportTypeEnum.fromCode((Integer)request.getDownloadType()).getName();
        CompletableFuture.runAsync(() -> {
            List entityList = this.invoiceBusiness.getInvoiceListByParams(request.getInvoiceIds(), null);
            if (CollectionUtils.isEmpty((Collection)entityList)) {
                this.setEmptyMsg(downloadName, userSessionInfo);
                return;
            }
            List operateList = entityList.stream().filter(r -> !StringHelp.safeIsEmpty((Object)r.getRecogInvoiceImageUrl()) || !StringHelp.safeIsEmpty((Object)r.getRecogDeductionImageUrl())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(operateList)) {
                this.setEmptyMsg(downloadName, userSessionInfo);
                return;
            }
            Integer invoiceSize = operateList.size();
            int count = 1;
            String dir = new File("").getAbsolutePath() + File.separator;
            for (int i = 0; i < operateList.size(); i += 300) {
                String countStr = String.format("%02d", count);
                String zipName = downloadName + "\u5f71\u50cf\u4e0b\u8f7d\uff08" + countStr + "\uff09_" + DateHelp.dateToString((Date)new Date()) + ".zip";
                List list = i + 300 > invoiceSize ? operateList.subList(i, invoiceSize) : operateList.subList(i, i + 300);
                this.invoiceExportBusiness.imageZipHandle(list, dir, zipName, userSessionInfo);
                ++count;
            }
        });
        if (request.getInvoiceIds().size() > 300) {
            return CommonResponse.ok((String)"\u5f71\u50cf\u6587\u4ef6\u8f83\u5927\uff0c\u53ef\u80fd\u9700\u8981\u8f83\u957f\u65f6\u95f4\u7b49\u5f85\uff0c\u8bf7\u7a0d\u540e\u53bb\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b.");
        }
        return CommonResponse.ok((String)"\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u53bb\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b.");
    }

    private void setEmptyMsg(String downloadName, UserSessionInfo userSessionInfo) {
        String messageTitle = downloadName + "\u5f71\u50cf\u4e0b\u8f7d_" + DateHelp.dateToString((Date)new Date()) + ".zip";
        String messageContent = String.format("\u4efb\u52a1\u63d0\u4ea4\u65f6\u95f4\uff1a%s \u4e0b\u8f7d\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u53d1\u7968\u5f71\u50cf\u6570\u636e", DateUtils.toDateStr((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
        this.messageBusiness.insert(Long.valueOf(userSessionInfo.getSysUserId()), MessageTypeEnum.BUSINESS_MESSAGE.getCode().intValue(), messageTitle, messageContent, "", DateConvert.getNowDate(), Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName());
    }
}

