/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.GetInvoiceListRequest;
import com.xforceplus.vanke.in.client.model.WkInvoiceDTO;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.service.invoice.InvoiceFilterBusiness;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetInvoiceListProcess
extends AbstractProcess<GetInvoiceListRequest, ListResult<WkInvoiceDTO>> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private InvoiceFilterBusiness invoiceFilterBusiness;

    protected void check(GetInvoiceListRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<ListResult<WkInvoiceDTO>> process(GetInvoiceListRequest request) throws RuntimeException {
        WkInvoiceExample example = new WkInvoiceExample();
        WkInvoiceExample.Criteria criteria = example.createCriteria();
        this.invoiceFilterBusiness.setInvoiceFilterExample(criteria, request);
        long count = this.wkInvoiceDao.countByExample(example);
        example.setLimit(request.getRows());
        example.setOffset(request.getOffset());
        if (ValidatorUtil.isNotEmpty((String)request.getOrderByClause())) {
            example.setOrderByClause(request.getOrderByClause());
        } else {
            example.setOrderByClause("paper_drew_date desc");
        }
        ListResult listResult = new ListResult(Long.valueOf(count), this.wkInvoiceDao.selectByExample(example).stream().map(entity -> {
            WkInvoiceDTO dto = new WkInvoiceDTO();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
    }
}

