/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.lang.DateTimeHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.in.client.model.InvoiceRepeatCountRequest;
import com.xforceplus.vanke.in.client.model.WkInvoiceDTO;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetInvoiceRepeatCountProcess
extends AbstractProcess<InvoiceRepeatCountRequest, ListResult<WkInvoiceDTO>> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;

    protected void check(InvoiceRepeatCountRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<ListResult<WkInvoiceDTO>> process(InvoiceRepeatCountRequest request) throws RuntimeException {
        WkInvoiceExample wkInvoiceExample = this.createExample(request);
        Long count = this.wkInvoiceDao.countByExample(wkInvoiceExample);
        wkInvoiceExample.setLimit(request.getRows());
        wkInvoiceExample.setOffset(request.getOffset());
        ListResult listResult = new ListResult(count, this.wkInvoiceDao.selectByExample(wkInvoiceExample).stream().map(entity -> {
            WkInvoiceDTO dto = new WkInvoiceDTO();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
    }

    public WkInvoiceExample createExample(InvoiceRepeatCountRequest request) {
        WkInvoiceExample wkInvoiceExample = new WkInvoiceExample();
        WkInvoiceExample.Criteria criteria = wkInvoiceExample.createCriteria();
        wkInvoiceExample.setOrderByClause("paper_drew_date desc");
        criteria.andIfRepeatEqualTo(Integer.valueOf(1));
        if (!StringHelp.safeIsEmpty((Object)request.getInvoiceCode())) {
            criteria.andInvoiceCodeEqualTo(request.getInvoiceCode());
        }
        if (!StringHelp.safeIsEmpty((Object)request.getInvoiceNo())) {
            criteria.andInvoiceNoEqualTo(request.getInvoiceNo());
        }
        if (!StringHelp.safeIsEmpty((Object)request.getPurchaserName())) {
            criteria.andPurchaserNameLike(request.getPurchaserName() + "%");
        }
        if (!StringHelp.safeIsEmpty((Object)request.getSellerName())) {
            criteria.andSellerNameLike(request.getSellerName() + "%");
        }
        if (!CollectionUtils.isEmpty((Collection)request.getPaperDrewDate()) && request.getPaperDrewDate().size() == 2) {
            criteria.andPaperDrewDateBetween(DateTimeHelp.formatLong((long)StringHelp.safeStringToLong((String)((String)request.getPaperDrewDate().get(0))), (String)"yyyyMMdd"), DateTimeHelp.formatLong((long)StringHelp.safeStringToLong((String)((String)request.getPaperDrewDate().get(1))), (String)"yyyyMMdd"));
        }
        if (!CollectionUtils.isEmpty((Collection)request.getAmountWithTax()) && request.getAmountWithTax().size() == 2) {
            if (!StringHelp.safeIsEmpty(request.getAmountWithTax().get(0))) {
                criteria.andAmountWithTaxGreaterThanOrEqualTo((BigDecimal)request.getAmountWithTax().get(0));
            }
            if (!StringHelp.safeIsEmpty(request.getAmountWithTax().get(1))) {
                criteria.andAmountWithTaxLessThanOrEqualTo((BigDecimal)request.getAmountWithTax().get(1));
            }
        }
        return wkInvoiceExample;
    }
}

