/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.excel.EasyExcelHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.vanke.in.client.model.InvoiceRepeatCountRequest;
import com.xforceplus.vanke.in.controller.invoice.process.GetInvoiceRepeatCountProcess;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.repository.param.InvoiceRepeatParam;
import com.xforceplus.vanke.sc.base.enums.Message.MessageTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.AuthStatusEnum;
import com.xforceplus.vanke.sc.base.enums.orders.OrderAuditStatusEnum;
import com.xforceplus.vanke.sc.base.exception.VankeException;
import com.xforceplus.vanke.sc.service.FileBusiness;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceRepeatExportProcess
extends AbstractProcess<InvoiceRepeatCountRequest, Boolean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private GetInvoiceRepeatCountProcess getInvoiceRepeatCountProcess;
    @Autowired
    private FileBusiness fileBusiness;
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(InvoiceRepeatCountRequest request) throws ValidationException {
        long day;
        super.check((BaseRequest)request);
        boolean isEmpty = false;
        try {
            isEmpty = ValidatorUtil.allFieldEmpty((Object)request);
        }
        catch (Exception e) {
            this.logger.error("\u5224\u65ad\u53c2\u6570\u662f\u5426\u4e3a\u7a7a\u5f02\u5e38!");
        }
        if (isEmpty) {
            throw new VankeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u90fd\u4e3a\u7a7a!");
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getPaperDrewDate()) && (day = (Long.valueOf((String)request.getPaperDrewDate().get(1)) - Long.valueOf((String)request.getPaperDrewDate().get(0))) / 86400000L) > 365L) {
            throw new VankeException("\u9009\u62e9\u65e5\u671f\u4e0d\u53ef\u5927\u4e8e\u4e00\u5e74\u524d!");
        }
    }

    protected CommonResponse<Boolean> process(InvoiceRepeatCountRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        Date date = new Date();
        WkInvoiceExample wkInvoiceExample = this.getInvoiceRepeatCountProcess.createExample(request);
        List wkInvoiceEntities = this.wkInvoiceDao.selectByExample(wkInvoiceExample);
        ArrayList invoiceRepeatParams = Lists.newArrayList();
        wkInvoiceEntities.stream().forEach(wkInvoiceEntity -> {
            InvoiceRepeatParam invoiceRepeatParam = new InvoiceRepeatParam();
            BeanUtils.copyProperties((Object)wkInvoiceEntity, (Object)invoiceRepeatParam);
            AuthStatusEnum authStatusEnum = AuthStatusEnum.fromCode((Integer)wkInvoiceEntity.getAuthStatus());
            String authStatus = authStatusEnum != null ? authStatusEnum.getName() : "";
            invoiceRepeatParam.setAuthStatus(authStatus);
            OrderAuditStatusEnum auditStatusEnum = OrderAuditStatusEnum.fromCode((Integer)wkInvoiceEntity.getAuditStatus());
            String auditStatus = auditStatusEnum != null ? auditStatusEnum.getName() : "";
            invoiceRepeatParam.setAuditStatus(auditStatus);
            invoiceRepeatParams.add(invoiceRepeatParam);
        });
        ByteArrayOutputStream outputStream = EasyExcelHelp.export((List)invoiceRepeatParams, (String)"\u53d1\u7968\u91cd\u590d\u7edf\u8ba1", InvoiceRepeatParam.class);
        String fileName = String.format("\u53d1\u7968\u91cd\u590d\u7edf\u8ba1_%s%s", DateUtils.curDateStr((String)"yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206"), ExcelTypeEnum.XLSX.getValue());
        String fileKey = this.fileBusiness.uploadFile(fileName, (InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        String messageCount = fileKey == null ? "\u5bfc\u51fa\u5931\u8d25,\u8bf7\u91cd\u8bd5!" : String.format("\u4efb\u52a1\u63d0\u4ea4\u65f6\u95f4\uff1a%s", DateUtils.toDateStr((Date)date, (String)"yyyy.MM.dd HH:mm:ss"));
        this.messageBusiness.insert(Long.valueOf(userSessionInfo.getAccountId()), MessageTypeEnum.BUSINESS_MESSAGE.getCode().intValue(), fileName, messageCount, fileKey, new Date(), Long.valueOf(userSessionInfo.getAccountId()), userSessionInfo.getSysUserName());
        return CommonResponse.ok((String)"\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u53bb\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b.");
    }
}

