/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.InvoiceSendExceptionRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.service.LogInvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.sc.base.enums.Exception.ExceptionTypeEnum;
import com.xforceplus.vanke.sc.base.enums.PostCode.ErrorTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.ExportTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.LogInvoiceActionEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.SendExceptionEnum;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceSendExceptionProcess
extends AbstractProcess<InvoiceSendExceptionRequest, Integer> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private LogInvoiceBusiness logInvoiceBusiness;

    protected void check(InvoiceSendExceptionRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getInvoiceIds(), "\u53d1\u7968ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty((Object)request.getIfSendException(), "\u662f\u5426\u8f6c\u4ea4\u5f02\u5e38\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        if (!SendExceptionEnum.CONFIRM.getCode().equals(request.getIfSendException()) && !SendExceptionEnum.CANCEL.getCode().equals(request.getIfSendException())) {
            throw new ValidationException("\u662f\u5426\u8f6c\u4ea4\u5f02\u5e38\u6807\u8bc6\u975e\u6cd5");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Integer> process(InvoiceSendExceptionRequest request) throws RuntimeException {
        List entityList = this.invoiceBusiness.getInvoiceListByParams(request.getInvoiceIds(), request.getIfSendException());
        if (!CollectionUtils.isEmpty((Collection)entityList)) {
            WkInvoiceEntity updateEntity = new WkInvoiceEntity();
            updateEntity.setIfSendException(request.getIfSendException());
            if (SendExceptionEnum.CONFIRM.getCode().equals(request.getIfSendException())) {
                updateEntity.setSendExceptionRemark(request.getSendExceptionRemark());
            }
            if (SendExceptionEnum.CANCEL.getCode().equals(request.getIfSendException())) {
                updateEntity.setSendExceptionRemark("");
            }
            this.wkInvoiceDao.updateByExampleSelective(updateEntity, this.invoiceBusiness.setWkInvoiceExampleByIds(entityList));
            UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
            if (null == userSessionInfo) {
                return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (SendExceptionEnum.CONFIRM.getCode().equals(request.getIfSendException())) {
                this.addException(entityList, userSessionInfo, request.getSendType(), request.getSendExceptionRemark());
                return CommonResponse.ok((String)(LogInvoiceActionEnum.SEND_EXCEPTION.getName() + "\u6210\u529f."));
            }
            entityList.parallelStream().forEach(item -> this.logInvoiceBusiness.addInvoiceHistory(item.getId(), LogInvoiceActionEnum.CANCEL_SEND_EXCEPTION.getCode(), "\u64a4\u9500\u5f02\u5e38\u53d1\u7968", Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName()));
            return CommonResponse.ok((String)(LogInvoiceActionEnum.CANCEL_SEND_EXCEPTION.getName() + "\u6210\u529f."));
        }
        return CommonResponse.failed((String)"\u6ca1\u6709\u627e\u5230\u53ef\u64cd\u4f5c\u7684\u53d1\u7968.");
    }

    private void addException(List<WkInvoiceEntity> entityList, UserSessionInfo userSessionInfo, Integer sendType, String errorRemark) {
        entityList.parallelStream().forEach(item -> {
            String errorType = ErrorTypeEnum.DELIVER.getCode();
            if (null != sendType && ExportTypeEnum.AUTH.getCode().equals(sendType)) {
                errorType = ErrorTypeEnum.AUTH.getCode();
            }
            this.invoiceBusiness.aAddExceInfo(item, userSessionInfo.getSysUserName(), ExceptionTypeEnum.INVOICE_EXCEPTION.getCode(), errorType, errorRemark);
            this.logInvoiceBusiness.addInvoiceHistory(item.getId(), LogInvoiceActionEnum.SEND_EXCEPTION.getCode(), "\u8f6c\u4ea4\u5f02\u5e38\u53d1\u7968", Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName());
        });
    }
}

