/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.InvoiceAmountBean;
import com.xforceplus.vanke.in.client.model.ModifyRecogRequest;
import com.xforceplus.vanke.in.client.model.SyncMainOpTypeBean;
import com.xforceplus.vanke.in.client.model.WkInvoiceDTO;
import com.xforceplus.vanke.in.repository.dao.SmInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.daoext.InvoiceDaoExt;
import com.xforceplus.vanke.in.repository.model.SmInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.service.LogInvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.ModifyRecogBusiness;
import com.xforceplus.vanke.in.service.invoice.sync.SmInvoiceSyncDeal;
import com.xforceplus.vanke.in.service.smfile.SmInvoiceBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceOrigEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.LogInvoiceActionEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.RecogStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.SyncOpTypeEnum;
import com.xforceplus.vanke.sc.utils.QueueSender;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ModifyRecogProcess
extends AbstractProcess<ModifyRecogRequest, InvoiceAmountBean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private SmInvoiceDao smInvoiceDao;
    @Autowired
    private SmInvoiceBusiness smInvoiceBusiness;
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private ModifyRecogBusiness modifyRecogBusiness;
    @Autowired
    private LogInvoiceBusiness logInvoiceBusiness;
    @Autowired
    private InvoiceDaoExt invoiceDaoExt;
    @Autowired
    private SmInvoiceSyncDeal smInvoiceSyncDeal;

    protected void check(ModifyRecogRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getInvoiceId(), "\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getOrderCode(), "\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<InvoiceAmountBean> process(ModifyRecogRequest request) throws RuntimeException {
        CommonResponse response;
        this.logger.info("\u4fee\u6539\u5f71\u50cf\u4f20\u53c2\uff1a{}", JSON.toJSON((Object)request));
        UserSessionInfo userSessionInfo = null;
        if (null == this.contextHolder || null == this.contextHolder.get()) {
            userSessionInfo = new UserSessionInfo();
            userSessionInfo.setSysUserId(Constants.LONG_ZERO.longValue());
            userSessionInfo.setSysUserName("\u7cfb\u7edf");
        } else {
            userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        }
        String errMsg = this.modifyRecogBusiness.checkRecogData(request);
        if (!StringHelp.safeIsEmpty((Object)errMsg) && !"true".equals(errMsg)) {
            return CommonResponse.failed((String)errMsg);
        }
        WkInvoiceEntity entity = this.wkInvoiceDao.selectByPrimaryKey(request.getInvoiceId());
        if (null == entity) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u627e\u5230\u53ef\u64cd\u4f5c\u7684\u53d1\u7968.");
        }
        if ((InvoiceOrigEnum.SCAN.getCode().equals(entity.getInvoiceOrig()) || InvoiceOrigEnum.VERI_ORIG.getCode().equals(entity.getInvoiceOrig())) && !CommonResponse.OK.equals((response = this.modifyRecogBusiness.checkAuth(entity.getAuthStatus(), request.getDoIfAuthedForA(), true)).getCode())) {
            return response;
        }
        List smList = this.smInvoiceBusiness.getSmInvoiceBybillCodeNo(entity.getSalesbillNo(), entity.getInvoiceCode(), entity.getInvoiceNo());
        if (CollectionUtils.isEmpty((Collection)smList)) {
            return CommonResponse.failed((String)("\u53d1\u7968\u53f7\u7801[" + entity.getInvoiceNo() + "]\u5f71\u50cf\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5."));
        }
        if (!(StringHelp.safeIsEmpty((Object)request.getInvoiceCode()) || StringHelp.safeIsEmpty((Object)request.getInvoiceNo()) || request.getInvoiceCode().equals(entity.getInvoiceCode()) && request.getInvoiceNo().equals(entity.getInvoiceNo()))) {
            this.logger.info("\u53d1\u7968\u4fee\u6539--\u4fee\u6539\u4e86\u4ee3\u7801\u6216\u53f7\u7801\uff0cACodeAndNo:[{}][{}],BCodeAndNo:[{}][{}]", new Object[]{entity.getInvoiceCode(), entity.getInvoiceNo(), request.getInvoiceCode(), request.getInvoiceNo()});
            return this.modifyWithCodeOrNo(entity, smList, request, userSessionInfo, errMsg);
        }
        this.logger.info("\u53d1\u7968\u4fee\u6539--\u672a\u4fee\u6539\u4ee3\u7801\u6216\u53f7\u7801\uff0cinvoiceId:[{}]", (Object)request.getInvoiceId());
        return this.modifyWithoutCodeOrNo(entity, smList, request, userSessionInfo, errMsg);
    }

    private CommonResponse modifyWithoutCodeOrNo(WkInvoiceEntity entity, List<SmInvoiceEntity> smList, ModifyRecogRequest request, UserSessionInfo userSessionInfo, String errMsg) {
        List salebillNoList = this.invoiceBusiness.checkRepeat(entity, request.getOrderCode(), true);
        if (!CollectionUtils.isEmpty((Collection)salebillNoList)) {
            InvoiceAmountBean resultBean = new InvoiceAmountBean();
            resultBean.setSalesbillList(salebillNoList);
            return CommonResponse.from((Integer)4, (String)"\u53d1\u7968\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539", (Object)resultBean);
        }
        smList.stream().filter(r -> r.getOrderCode().equals(request.getOrderCode())).forEach(r -> {
            SmInvoiceEntity upSmEntity = this.modifyRecogBusiness.getNewSmInvoice(request, false, r);
            upSmEntity.setId(r.getId());
            this.smInvoiceDao.updateByPrimaryKeySelective(upSmEntity);
        });
        this.logInvoiceBusiness.addInvoiceHistory(entity.getId(), LogInvoiceActionEnum.RECOG_MANUAL_MODIFY.getCode(), userSessionInfo.getSysUserName() + "\u624b\u52a8\u4fee\u6539\u4e86\u53d1\u7968\u626b\u63cf\u4fe1\u606f.", Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName());
        List invoiceIds = smList.stream().map(r -> r.getId()).collect(Collectors.toList());
        HashMap propertys = Maps.newHashMap();
        propertys.put("isGxInterface", "0");
        propertys.put("isModify", "1");
        QueueSender.textSend((String)"scanInvoiceSyncDealQueue", (String)JSON.toJSONString(invoiceIds), (Map)propertys);
        if ("true".equals(errMsg)) {
            return CommonResponse.ok((String)"\u4fee\u6539\u6210\u529f\uff0c\u8d2d\u65b9\u7a0e\u53f7\u5728\u6cd5\u4eba\u4e3b\u6570\u636e\u4e0d\u5b58\u5728!", (Object)this.modifyRecogBusiness.getInvoiceAmount(entity.getSalesbillNo()));
        }
        return CommonResponse.ok((String)"\u4fee\u6539\u6210\u529f.", (Object)this.modifyRecogBusiness.getInvoiceAmount(entity.getSalesbillNo()));
    }

    private CommonResponse modifyWithCodeOrNo(WkInvoiceEntity entityA, List<SmInvoiceEntity> smListA, ModifyRecogRequest request, UserSessionInfo userSessionInfo, String errMsg) {
        List tempListB;
        WkInvoiceEntity entityB = null;
        List entityListB = this.invoiceBusiness.getInvoiceInfoByCodeNo(request.getInvoiceCode(), request.getInvoiceNo());
        if (!CollectionUtils.isEmpty((Collection)entityListB)) {
            CommonResponse response;
            entityB = (WkInvoiceEntity)entityListB.get(0);
            if (!StringHelp.safeIsEmpty((Object)entityB.getSalesbillNo()) && entityB.getSalesbillNo().equals(request.getOrderCode()) && RecogStatusEnum.RECOG_OK.getCode().equals(entityB.getRecogStatus())) {
                return CommonResponse.from((Integer)4, (String)"\u53d1\u7968\u3010\u4ee3\u7801-\u53f7\u7801\u3011\u5f71\u50cf\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u4fee\u6539\uff0c\u82e5\u8981\u4fee\u6539\uff0c\u8bf7\u5148\u5220\u9664\u5f71\u50cf\u540e\u518d\u4fee\u6539!");
            }
            List salebillNoList = this.invoiceBusiness.checkRepeat(entityB, request.getOrderCode(), true);
            InvoiceAmountBean resultBean = new InvoiceAmountBean();
            resultBean.setSalesbillList(salebillNoList);
            if (!CollectionUtils.isEmpty((Collection)salebillNoList)) {
                return CommonResponse.from((Integer)4, (String)"\u53d1\u7968\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539", (Object)resultBean);
            }
            if ((InvoiceOrigEnum.SCAN.getCode().equals(entityB.getInvoiceOrig()) || InvoiceOrigEnum.VERI_ORIG.getCode().equals(entityB.getInvoiceOrig())) && !CommonResponse.OK.equals((response = this.modifyRecogBusiness.checkAuth(entityB.getAuthStatus(), request.getDoIfAuthedForB(), false)).getCode())) {
                return response;
            }
        }
        if ("1".equals(entityA.getInvoiceCode()) && "2".equals(entityA.getInvoiceNo())) {
            return this.modifyWithoutCodeOrNo12(entityA, smListA, request, userSessionInfo, errMsg, entityB);
        }
        List tempListA = this.smInvoiceBusiness.getSmInvoiceBybillCodeNo(request.getOrderCode(), entityA.getInvoiceCode(), entityA.getInvoiceNo());
        tempListA.stream().forEach(r -> {
            SmInvoiceEntity upSmEntity = this.modifyRecogBusiness.getNewSmInvoice(request, false, r);
            upSmEntity.setId(r.getId());
            this.smInvoiceDao.updateByPrimaryKeySelective(upSmEntity);
        });
        if (!CollectionUtils.isEmpty((Collection)tempListA)) {
            this.invoiceDaoExt.deleteOrderInvoiceRelation(request.getOrderCode(), entityA.getId());
            List invoiceIds = tempListA.stream().map(r -> r.getId()).collect(Collectors.toList());
            HashMap propertys = Maps.newHashMap();
            propertys.put("isGxInterface", "0");
            propertys.put("isModify", "1");
            QueueSender.textSend((String)"scanInvoiceSyncDealQueue", (String)JSON.toJSONString(invoiceIds), (Map)propertys);
        }
        if (!CollectionUtils.isEmpty((Collection)(tempListB = this.smInvoiceBusiness.getSmInvoiceByCodeNo(entityA.getInvoiceCode(), entityA.getInvoiceNo())))) {
            List salebillList = tempListB.stream().map(r -> r.getOrderCode()).distinct().collect(Collectors.toList());
            for (String r2 : salebillList) {
                this.invoiceDaoExt.deleteOrderInvoiceRelation(r2, entityA.getId());
            }
            List invoiceIds = tempListB.stream().map(r -> r.getId()).collect(Collectors.toList());
            HashMap propertys = Maps.newHashMap();
            propertys.put("isGxInterface", "0");
            propertys.put("isModify", "1");
            QueueSender.textSend((String)"scanInvoiceSyncDealQueue", (String)JSON.toJSONString(invoiceIds), (Map)propertys);
        }
        this.logInvoiceBusiness.addInvoiceHistory(entityA.getId(), LogInvoiceActionEnum.RECOG_MANUAL_MODIFY.getCode(), userSessionInfo.getSysUserName() + "\u624b\u52a8\u4fee\u6539\u4e86\u53d1\u7968\u626b\u63cf\u4fe1\u606f.", Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName());
        this.modifyRecogBusiness.updateAData(entityA, userSessionInfo, request.getOrderCode());
        if ("true".equals(errMsg)) {
            return CommonResponse.ok((String)"\u4fee\u6539\u6210\u529f\uff0c\u8d2d\u65b9\u7a0e\u53f7\u5728\u6cd5\u4eba\u4e3b\u6570\u636e\u4e0d\u5b58\u5728!", (Object)this.modifyRecogBusiness.getInvoiceAmount(entityA.getSalesbillNo()));
        }
        return CommonResponse.ok((String)"\u4fee\u6539\u6210\u529f", (Object)this.modifyRecogBusiness.getInvoiceAmount(entityA.getSalesbillNo()));
    }

    private CommonResponse modifyWithoutCodeOrNo12(WkInvoiceEntity entityA, List<SmInvoiceEntity> smListA, ModifyRecogRequest request, UserSessionInfo userSessionInfo, String errMsg, WkInvoiceEntity entityB) {
        List updateList = smListA.stream().filter(r -> r.getOrderCode().equals(request.getOrderCode())).map(r -> {
            SmInvoiceEntity upSmEntity = this.modifyRecogBusiness.getNewSmInvoice(request, false, r);
            upSmEntity.setId(r.getId());
            this.smInvoiceDao.updateByPrimaryKeySelective(upSmEntity);
            return upSmEntity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(updateList)) {
            return CommonResponse.failed((String)"\u4fee\u6539\u5931\u8d25");
        }
        WkInvoiceDTO wkInvoiceDTO = new WkInvoiceDTO();
        SyncMainOpTypeBean typeBean = new SyncMainOpTypeBean();
        if (null != entityB) {
            BeanUtils.copyProperties((Object)entityB, (Object)wkInvoiceDTO);
            typeBean.setOpType(SyncOpTypeEnum.UPDATE.getCode().intValue());
            typeBean.setOpInvoiceId(entityB.getId());
        } else {
            BeanUtils.copyProperties((Object)entityA, (Object)wkInvoiceDTO);
            typeBean.setOpType(SyncOpTypeEnum.COVER.getCode().intValue());
            typeBean.setOpInvoiceId(entityA.getId());
        }
        typeBean.setInvoiceDTO(wkInvoiceDTO);
        wkInvoiceDTO.setInvoiceCode(request.getInvoiceCode());
        wkInvoiceDTO.setInvoiceNo(request.getInvoiceNo());
        this.smInvoiceSyncDeal.updateInvoiceInfo((SmInvoiceEntity)updateList.get(0), typeBean, InvoiceOrigEnum.SCAN.getCode(), false);
        if (!StringHelp.safeIsEmpty((Object)wkInvoiceDTO.getSalesbillNo())) {
            QueueSender.textSend((String)"checkInvoiceDealQueue", (String)wkInvoiceDTO.getSalesbillNo(), null);
        }
        this.modifyRecogBusiness.isLoadPushGx(wkInvoiceDTO.getId());
        if (null != entityB) {
            this.wkInvoiceDao.deleteByPrimaryKey(entityA.getId());
        }
        this.logInvoiceBusiness.addInvoiceHistory(wkInvoiceDTO.getId(), LogInvoiceActionEnum.RECOG_MANUAL_MODIFY.getCode(), userSessionInfo.getSysUserName() + "\u624b\u52a8\u4fee\u6539\u4e86\u53d1\u7968\u626b\u63cf\u4fe1\u606f.", Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName());
        if ("true".equals(errMsg)) {
            return CommonResponse.ok((String)"\u4fee\u6539\u6210\u529f\uff0c\u8d2d\u65b9\u7a0e\u53f7\u5728\u6cd5\u4eba\u4e3b\u6570\u636e\u4e0d\u5b58\u5728!", (Object)this.modifyRecogBusiness.getInvoiceAmount(entityA.getSalesbillNo()));
        }
        return CommonResponse.ok((String)"\u4fee\u6539\u6210\u529f.", (Object)this.modifyRecogBusiness.getInvoiceAmount(entityA.getSalesbillNo()));
    }
}

