/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.InvoiceInfoRequest;
import com.xforceplus.vanke.in.repository.dao.SmInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.SmInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.SmInvoiceExample;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.base.enums.IsOrNo;
import com.xforceplus.vanke.sc.base.enums.invoice.DataFromSystemEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.FpztEnum;
import com.xforceplus.vanke.sc.outer.api.imsCore.entity.baseinfo.Response;
import com.xforceplus.vanke.sc.outer.pyt.PYTInterfaceImpl;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SyncDeleteInvoiceImageProcess
extends AbstractProcess<InvoiceInfoRequest, Boolean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private SmInvoiceDao smInvoiceDao;
    @Autowired
    private PYTInterfaceImpl pytInterface;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(InvoiceInfoRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getInvoiceId(), "\u53d1\u7968id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommonResponse<Boolean> process(InvoiceInfoRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        WkInvoiceEntity wkInvoiceEntity = this.wkInvoiceDao.selectByPrimaryKey(request.getInvoiceId());
        if (wkInvoiceEntity == null) {
            return CommonResponse.failed((String)"\u53d1\u7968\u4e0d\u5b58\u5728");
        }
        SmInvoiceExample example = new SmInvoiceExample();
        example.createCriteria().andOrderCodeEqualTo(wkInvoiceEntity.getSalesbillNo()).andBillCodeEqualTo(wkInvoiceEntity.getInvoiceCode()).andBillNumberEqualTo(wkInvoiceEntity.getInvoiceNo());
        List smInvoiceEntities = this.smInvoiceDao.selectByExample(example);
        if (ValidatorUtil.isEmpty((Collection)smInvoiceEntities)) {
            return CommonResponse.failed((String)"\u672a\u627e\u5230\u53d1\u7968\u5f71\u50cf, \u65e0\u6cd5\u63a8\u9001\u5220\u9664\u534f\u540c");
        }
        List<SmInvoiceEntity> list = smInvoiceEntities.stream().filter(entity -> FpztEnum.DELETE.getCode().equals(entity.getFpzt())).filter(entity -> DataFromSystemEnum.XYJ.getCode().equals(entity.getSourceSystem())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return CommonResponse.failed((String)"\u672a\u627e\u5230\u3010\u534f\u540c\u3001\u5df2\u5220\u9664\u3011\u7684\u53d1\u7968\u5f71\u50cf, \u65e0\u6cd5\u63a8\u9001\u5220\u9664\u534f\u540c");
        }
        String message = "";
        try {
            Response response = this.pytInterface.deleteInvoiceImage(wkInvoiceEntity.getSalesbillNo(), wkInvoiceEntity.getInvoiceCode(), wkInvoiceEntity.getInvoiceNo());
            if (response.getCode() == Response.OK) {
                list.forEach(entity -> {
                    entity.setIsPushImgDelXYJ(IsOrNo.YES.getCode());
                    this.smInvoiceDao.updateByPrimaryKeySelective(entity);
                });
                message = String.format("\u53d1\u7968\u3010%s-%s\u3011\u5f71\u50cf\u5220\u9664\u534f\u540c\u63a8\u9001\u6210\u529f", wkInvoiceEntity.getInvoiceCode(), wkInvoiceEntity.getInvoiceNo());
                CommonResponse commonResponse = CommonResponse.ok((String)message, (Object)true);
                return commonResponse;
            }
            message = String.format("\u53d1\u7968\u3010%s-%s\u3011\u5f71\u50cf\u5220\u9664\u534f\u540c\u63a8\u9001\u5931\u8d25\uff1a%s", wkInvoiceEntity.getInvoiceCode(), wkInvoiceEntity.getInvoiceNo(), response.getMessage());
            CommonResponse commonResponse = CommonResponse.failed((String)message);
            return commonResponse;
        }
        finally {
            this.logOperationsBusiness.saveLogOperations(wkInvoiceEntity.getSalesbillNo(), OpsTypeEnum.DEL_SYNC_IMAGE_GX.getCode(), userSessionInfo.getSysUserName(), message, wkInvoiceEntity.getInvoiceNo(), wkInvoiceEntity.getInvoiceCode());
        }
    }
}

