/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.InvoiceInfoRequest;
import com.xforceplus.vanke.in.repository.dao.SmInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.SmInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.DataFromSystemEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.RecogStatusEnum;
import com.xforceplus.vanke.sc.outer.api.imsCore.entity.baseinfo.Response;
import com.xforceplus.vanke.sc.outer.pyt.PYTInterfaceImpl;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Date;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SyncUploadInvoiceImageProcess
extends AbstractProcess<InvoiceInfoRequest, Boolean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private SmInvoiceDao smInvoiceDao;
    @Autowired
    private PYTInterfaceImpl pytInterface;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(InvoiceInfoRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getInvoiceId(), "\u53d1\u7968id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<Boolean> process(InvoiceInfoRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        WkInvoiceEntity wkInvoiceEntity = this.wkInvoiceDao.selectByPrimaryKey(request.getInvoiceId());
        if (wkInvoiceEntity == null) {
            return CommonResponse.failed((String)"\u53d1\u7968\u4e0d\u5b58\u5728");
        }
        if (!RecogStatusEnum.RECOG_OK.getCode().equals(wkInvoiceEntity.getRecogStatus()) || ValidatorUtil.isEmpty((Object)wkInvoiceEntity.getRecogInvoiceId()) || wkInvoiceEntity.getRecogInvoiceId() <= 0L) {
            return CommonResponse.failed((String)"\u53d1\u7968\u672a\u8bc6\u522b\uff0c\u65e0\u6cd5\u4e0a\u4f20\u5f71\u50cf");
        }
        SmInvoiceEntity smInvoiceEntity = this.smInvoiceDao.selectByPrimaryKey(wkInvoiceEntity.getRecogInvoiceId());
        if (smInvoiceEntity == null) {
            return CommonResponse.failed((String)"\u53d1\u7968\u6ca1\u6709\u5f71\u50cf, \u65e0\u6cd5\u4e0a\u4f20");
        }
        if (!DataFromSystemEnum.XYJ.getCode().equals(smInvoiceEntity.getSourceSystem())) {
            return CommonResponse.failed((String)"\u53d1\u7968\u5f71\u50cf\u4e0d\u662f\u626b\u63cf\u5f71\u50cf, \u65e0\u6cd5\u4e0a\u4f20");
        }
        JSONObject params = new JSONObject();
        JSONObject attr = new JSONObject();
        params.put("attr", (Object)attr);
        attr.put("invoice", (Object)JSON.toJSONString((Object)wkInvoiceEntity));
        Response response = null;
        try {
            response = this.pytInterface.uploadInvoiceImage(params.toJSONString());
            if (!Response.OK.equals(response.getCode())) {
                return CommonResponse.failed((String)("\u5f71\u50cf\u4e0a\u4f20\u5931\u8d25\uff1a" + response.getMessage()));
            }
            this.logger.debug("\u4e0a\u4f20\u6210\u529f");
            smInvoiceEntity.setCooperationSerialNo(StringHelp.safeToString((Object)response.getResult()));
            smInvoiceEntity.setInvoiceScanTime(new Date());
            this.smInvoiceDao.updateByPrimaryKeySelective(smInvoiceEntity);
        }
        catch (Exception e) {
            return CommonResponse.failed((String)"\u5f71\u50cf\u4e0a\u4f20\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        String message = String.format("\u53d1\u7968\u3010id:%d\u3011\u5f71\u50cf\u4e0a\u4f20\u6210\u529f", wkInvoiceEntity.getId());
        this.logOperationsBusiness.saveLogOperations(wkInvoiceEntity.getSalesbillNo(), OpsTypeEnum.UPLOAD_INVOICE_IMAGE.getCode(), userSessionInfo.getSysUserName(), message, wkInvoiceEntity.getInvoiceNo(), wkInvoiceEntity.getInvoiceCode());
        if (ValidatorUtil.isNotEmpty((String)smInvoiceEntity.getCooperationSerialNo())) {
            return CommonResponse.ok((String)("\u5f71\u50cf\u4e0a\u4f20\u6210\u529f\u5e76\u8986\u76d6cooperationSerialNo:" + response.getResult()), (Object)true);
        }
        return CommonResponse.ok((String)"\u5f71\u50cf\u4e0a\u4f20\u6210\u529f", (Object)true);
    }
}

