/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceauth.process;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xforceplus.landedestate.basecommon.help.excel.EasyExcelHelp;
import com.xforceplus.landedestate.basecommon.help.lang.DateConvert;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.vanke.in.client.model.AuthImportBean;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceImportBusiness;
import com.xforceplus.vanke.in.service.invoice.sync.tools.InvoiceSyncMainTools;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.IsOrNo;
import com.xforceplus.vanke.sc.base.enums.Message.MessageTypeEnum;
import com.xforceplus.vanke.sc.base.enums.company.AuthTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.AuthStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceTypeEnum;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonEntity;
import com.xforceplus.vanke.sc.service.FileBusiness;
import com.xforceplus.vanke.sc.service.LegalPersonBusiness;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AuthImportProcess {
    private static final Logger logger = LoggerFactory.getLogger(AuthImportProcess.class);
    @Autowired
    private InvoiceImportBusiness invoiceImportBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private FileBusiness fileBusiness;
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private InvoiceSyncMainTools invoiceSyncMainTools;
    @Autowired
    private LegalPersonBusiness legalPersonBusiness;

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<Boolean> process(MultipartFile file) throws RuntimeException {
        long a = System.currentTimeMillis();
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == file) {
            return CommonResponse.failed((String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        if (!file.getOriginalFilename().endsWith(".xls") && !file.getOriginalFilename().endsWith(".xlsx")) {
            return CommonResponse.failed((String)"\u5bfc\u5165\u7684\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff01\u8bf7\u5bfc\u5165xls\u6216xlxs\u7c7b\u578b\u6587\u4ef6.");
        }
        try {
            List importBeans = EasyExcelHelp.readExcel((InputStream)new BufferedInputStream(file.getInputStream()), AuthImportBean.class);
            if (CollectionUtils.isEmpty((Collection)importBeans)) {
                return CommonResponse.failed((String)"\u5bfc\u5165\u5931\u8d25,\u6587\u6863\u4e0d\u5b58\u5728\u5bfc\u5165\u6570\u636e.");
            }
            if (importBeans.size() > 2000) {
                return CommonResponse.failed((String)"\u5355\u6b21\u5bfc\u5165\u4e0a\u96502000\u6761\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165.");
            }
            Map checkMap = this.invoiceImportBusiness.checkBasicData(importBeans);
            List importFailedList = (List)checkMap.get("importFailedList");
            List tempSuccList = (List)checkMap.get("tempSuccList");
            if (!CollectionUtils.isEmpty((Collection)tempSuccList)) {
                List resultList = this.invoiceImportBusiness.getInvoiceByCodeNoList(tempSuccList);
                this.updateInvoiceData(tempSuccList, resultList, importFailedList, userSessionInfo);
                List salesbillList = resultList.stream().filter(r -> !StringHelp.safeIsEmpty((Object)r.getSalesbillNo())).map(r -> r.getSalesbillNo()).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(salesbillList)) {
                    salesbillList.stream().forEach(r -> this.invoiceSyncMainTools.checkOrderAuthTime(r));
                }
            }
            String fileName = "\u53d1\u7968\u62b5\u6263\u5bfc\u5165_" + DateHelp.dateToString((Date)new Date()) + ".xlsx";
            String exportFileUrl = "";
            if (!CollectionUtils.isEmpty((Collection)importFailedList)) {
                ByteArrayOutputStream outputStream = EasyExcelHelp.export((List)importFailedList, (String)"\u62b5\u6263\u5bfc\u5165", AuthImportBean.class);
                exportFileUrl = this.fileBusiness.uploadFile(fileName, (InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                logger.debug("\u62b5\u6263\u5bfc\u5165\u4e0a\u4f20\u6587\u4ef6\u5730\u5740\uff1a{}", (Object)exportFileUrl);
            }
            StringBuffer messageContent = new StringBuffer("\u4efb\u52a1\u63d0\u4ea4\u65f6\u95f4\uff1a" + DateUtils.toDateStr((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
            if (importFailedList.size() > 0 && importFailedList.size() < importBeans.size()) {
                messageContent.append(" \u5bfc\u5165\u6210\u529f\uff1a").append(importBeans.size() - importFailedList.size()).append("\u6761").append("\uff0c\u5931\u8d25\uff1a").append(importFailedList.size()).append("\u6761");
            } else if (importFailedList.size() == importBeans.size()) {
                messageContent.append(" \u5168\u90e8\u5bfc\u5165\u5931\u8d25\u5171\uff1a").append(importFailedList.size()).append("\u6761");
            } else {
                messageContent.append(" \u5168\u90e8\u5bfc\u5165\u6210\u529f\u5171\uff1a").append(importBeans.size()).append("\u6761");
            }
            this.messageBusiness.insert(Long.valueOf(userSessionInfo.getSysUserId()), MessageTypeEnum.BUSINESS_MESSAGE.getCode().intValue(), fileName, exportFileUrl == null ? "\u5bfc\u51fa\u5931\u8d25,\u8bf7\u91cd\u8bd5!" : messageContent.toString(), exportFileUrl, DateConvert.getNowDate(), Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName());
            logger.info("\u62b5\u6263\u5bfc\u5165\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - a));
            return CommonResponse.ok((String)"\u5bfc\u5165\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u53bb\u6d88\u606f\u4e2d\u5fc3\u4e0b\u8f7d.");
        }
        catch (Exception e) {
            logger.error("\u62b5\u6263\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.failed((String)"\u62b5\u6263\u5bfc\u5165\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u6b63\u786e.");
        }
    }

    private void updateInvoiceData(List<AuthImportBean> tempSuccList, List<WkInvoiceEntity> resultList, List<AuthImportBean> importFailedList, UserSessionInfo userSessionInfo) {
        HashMap blockTaxNoMap = Maps.newHashMap();
        Map<String, List<WkInvoiceEntity>> tempMap = resultList.stream().collect(Collectors.groupingBy(r -> r.getInvoiceNo() + r.getInvoiceCode()));
        tempSuccList.stream().forEach(item -> {
            if (tempMap.get(item.getInvoiceNo() + item.getInvoiceCode()) == null) {
                item.setAuthResult("\u53d1\u7968\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53f7\u7801\u4ee3\u7801");
                importFailedList.add((AuthImportBean)item);
                return;
            }
            WkInvoiceEntity invoiceEntity = (WkInvoiceEntity)((List)tempMap.get(item.getInvoiceNo() + item.getInvoiceCode())).get(0);
            if (!(AuthStatusEnum.NOT_AUTH.getCode().equals(invoiceEntity.getAuthStatus()) || AuthStatusEnum.FAILED.getCode().equals(invoiceEntity.getAuthStatus()) || AuthStatusEnum.DEFAULT.getCode().equals(invoiceEntity.getAuthStatus()) || AuthStatusEnum.CAN_NOT_AUTH.getCode().equals(invoiceEntity.getAuthStatus()))) {
                item.setAuthResult("\u53d1\u7968\u4e0d\u6ee1\u8db3\u4fee\u6539\u62b5\u6263\u72b6\u6001\u6761\u4ef6");
                importFailedList.add((AuthImportBean)item);
                return;
            }
            if (Constants.NUMBER_ONE.toString().equals(item.getAuthResult()) || Constants.NUMBER_TWO.toString().equals(item.getAuthResult())) {
                if (AuthStatusEnum.IN_AUTH.getCode().equals(invoiceEntity.getAuthStatus())) {
                    item.setAuthResult("\u53d1\u7968\u52fe\u9009\u4e2d\uff0c\u4e0d\u53ef\u5bfc\u5165");
                    importFailedList.add((AuthImportBean)item);
                    return;
                }
                if (!InvoiceTypeEnum.SPECIAL.value().equals(invoiceEntity.getInvoiceType())) {
                    item.setAuthResult("\u53d1\u7968\u7c7b\u578b\u4e0d\u53ef\u62b5\u6263\uff0c\u8bf7\u68c0\u67e5");
                    importFailedList.add((AuthImportBean)item);
                    return;
                }
                if (!StringHelp.safeIsEmpty((Object)invoiceEntity.getPaperDrewDate())) {
                    String paperDrewDateStr = invoiceEntity.getPaperDrewDate().substring(0, 6);
                    if (item.getTaxPeriod().compareTo(paperDrewDateStr) < 0) {
                        item.setAuthResult("\u6240\u5c5e\u671f\u9700\u5927\u4e8e\u5f00\u7968\u65e5\u671f\u6708\u4efd\uff0c\u8bf7\u68c0\u67e5");
                        importFailedList.add((AuthImportBean)item);
                        return;
                    }
                }
                Integer isLock = IsOrNo.NO.getCode();
                boolean isEl = false;
                if (blockTaxNoMap.get(invoiceEntity.getPurchaserTaxNo()) != null) {
                    isLock = (Integer)blockTaxNoMap.get(invoiceEntity.getPurchaserTaxNo());
                } else {
                    WkLegalPersonEntity legalEntity = this.legalPersonBusiness.getLegalPersonListByRelTax(invoiceEntity.getPurchaserTaxNo());
                    if (null != legalEntity && null != legalEntity.getIsBlockade()) {
                        isLock = legalEntity.getIsBlockade();
                        blockTaxNoMap.put(invoiceEntity.getPurchaserTaxNo(), isLock);
                    }
                    if (AuthTypeEnum.ELECTRONIC_ACCOUNT.getCode().equals(legalEntity.getAuthType()) || AuthTypeEnum.ALL_OK.getCode().equals(legalEntity.getAuthType())) {
                        isEl = true;
                    }
                }
                if (IsOrNo.YES.getCode().equals(isLock) && isEl) {
                    item.setAuthResult("\u53d1\u7968\u6240\u5c5e\u8d2d\u65b9\u7a0e\u53f7\u5904\u4e8e\u5c01\u9501\u4e2d\u4e0d\u53ef\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5");
                    importFailedList.add((AuthImportBean)item);
                    return;
                }
                this.invoiceImportBusiness.updateAuthStatusSuccess(invoiceEntity, userSessionInfo, item.getTaxPeriod(), item.getAuthTime(), item.getAuthMethod(), Integer.valueOf(StringHelp.safeStringToInt((String)item.getAuthResult())), "yyyy/MM/dd HH:mm", JSON.toJSONString((Object)item));
            }
            if (Constants.NUMBER_ZERO.toString().equals(item.getAuthResult())) {
                this.invoiceImportBusiness.cancelAuth(invoiceEntity, userSessionInfo);
            }
        });
    }
}

