/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceauth.process;

import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.AuthStatisticsDetailBean;
import com.xforceplus.vanke.in.client.model.AuthStatisticsInfoBean;
import com.xforceplus.vanke.in.client.model.AuthSummaryRequest;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceAuthBusiness;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceSummaryBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.common.AuthSummaryEnum;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuthSummaryDetailProcess
extends AbstractProcess<AuthSummaryRequest, AuthStatisticsInfoBean> {
    @Autowired
    private InvoiceSummaryBusiness invoiceSummaryBusiness;
    @Autowired
    private InvoiceAuthBusiness invoiceAuthBusiness;

    protected void check(AuthSummaryRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getSummaryType(), "\u6c47\u603b\u7c7b\u578b\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getTaxPeriod(), "\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        if (!Constants.NUMBER_ZERO.equals(request.getSummaryType())) {
            this.checkEmpty(request.getCompanyTaxNo(), "\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected CommonResponse<AuthStatisticsInfoBean> process(AuthSummaryRequest request) throws RuntimeException {
        AuthStatisticsInfoBean authStatisticsInfoBean = new AuthStatisticsInfoBean();
        String lastPeriod = DateHelp.getLastMonthByMonth((String)request.getTaxPeriod());
        List summaryList = this.invoiceSummaryBusiness.selectAuthSummay(request.getCompanyTaxNo(), lastPeriod, request.getTaxPeriod());
        List companyTaxNoList = summaryList.stream().map(r -> r.getPurchaserTaxNo()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(companyTaxNoList)) {
            companyTaxNoList.add(request.getCompanyTaxNo());
        }
        Map periodMap = this.invoiceAuthBusiness.getAuthPeriodMap(companyTaxNoList);
        List allCompanyInfoList = this.invoiceSummaryBusiness.setStatisticRate(summaryList, companyTaxNoList, request.getTaxPeriod(), lastPeriod, request.getSummaryType(), periodMap);
        if (request.getSummaryType().equals(Constants.NUMBER_ZERO)) {
            AuthStatisticsDetailBean tenantInfo = new AuthStatisticsDetailBean();
            this.setTenantInfo(allCompanyInfoList, companyTaxNoList, tenantInfo);
            List companyInfoList = allCompanyInfoList.stream().filter(r -> !StringHelp.safeIsEmpty((Object)r.getDeclareTime()) && r.getItemType().equals(AuthSummaryEnum.CURRENT.getCode())).collect(Collectors.toList());
            this.invoiceSummaryBusiness.setSortedList(companyInfoList, request.getOrderNo());
            authStatisticsInfoBean.setTenantInfo(tenantInfo);
            authStatisticsInfoBean.setCompanyInfo(companyInfoList);
            return CommonResponse.ok((String)"\u6210\u529f", (Object)authStatisticsInfoBean);
        }
        List companyInfoList = allCompanyInfoList.stream().filter(r -> !StringHelp.safeIsEmpty((Object)r.getDeclareTime()) && r.getItemType().equals(1) && r.getCompanyTaxNo().equals(request.getCompanyTaxNo())).collect(Collectors.toList());
        authStatisticsInfoBean.setCompanyInfo(companyInfoList);
        return CommonResponse.ok((String)"\u6210\u529f", (Object)authStatisticsInfoBean);
    }

    private void setTenantInfo(List<AuthStatisticsDetailBean> allCompanyInfoList, List<String> companyTaxNoList, AuthStatisticsDetailBean tenantInfo) {
        int companyNum = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(AuthSummaryEnum.CURRENT.getCode()) && r.getDeclaredCompanyNum() > 0).mapToInt(r -> r.getDeclaredCompanyNum()).sum();
        tenantInfo.setDeclaredCompanyNum(Integer.valueOf(companyNum));
        tenantInfo.setUndeclaredCompanyNum(Integer.valueOf(companyTaxNoList.size() - companyNum));
        int invoiceNum = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(AuthSummaryEnum.CURRENT.getCode()) && r.getDeclaredCompanyNum() > 0).mapToInt(r -> r.getInvoiceNum()).sum();
        tenantInfo.setInvoiceNum(Integer.valueOf(invoiceNum));
        BigDecimal taxAmount = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(AuthSummaryEnum.CURRENT.getCode()) && r.getDeclaredCompanyNum() > 0).map(r -> r.getTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        tenantInfo.setTaxAmount(taxAmount);
        int lastInvoiceNum = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(AuthSummaryEnum.DECLARE.getCode()) && r.getDeclaredCompanyNum() > 0).mapToInt(r -> r.getInvoiceNum()).sum();
        this.invoiceSummaryBusiness.setLastInvoiceRate(Integer.valueOf(lastInvoiceNum), Integer.valueOf(invoiceNum), tenantInfo);
        BigDecimal lastTaxAmount = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(0) && r.getDeclaredCompanyNum() > 0).map(r -> r.getTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (lastTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
            Double taxAmountRate = taxAmount.subtract(lastTaxAmount).divide(lastTaxAmount, 2, 4).doubleValue() * 100.0;
            tenantInfo.setTaxAmountRate(Integer.valueOf(taxAmountRate.intValue()));
        } else {
            tenantInfo.setTaxAmountRate(Constants.NUMBER_ZERO);
        }
        int sInvoiceNum = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(AuthSummaryEnum.CURRENT.getCode()) && r.getDeclaredCompanyNum() > 0).mapToInt(r -> r.getSpInvoiceNum()).sum();
        int jInvoiceNum = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(AuthSummaryEnum.CURRENT.getCode()) && r.getDeclaredCompanyNum() > 0).mapToInt(r -> r.getVpInvoiceNum()).sum();
        int ctInvoiceNum = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(AuthSummaryEnum.CURRENT.getCode()) && r.getDeclaredCompanyNum() > 0).mapToInt(r -> r.getCtInvoiceNum()).sum();
        BigDecimal sTaxAmount = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(AuthSummaryEnum.CURRENT.getCode()) && r.getDeclaredCompanyNum() > 0).map(r -> r.getSpTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal jTaxAmount = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(AuthSummaryEnum.CURRENT.getCode()) && r.getDeclaredCompanyNum() > 0).map(r -> r.getVpTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ctTaxAmount = allCompanyInfoList.stream().filter(r -> r.getItemType().equals(AuthSummaryEnum.CURRENT.getCode()) && r.getDeclaredCompanyNum() > 0).map(r -> r.getCtTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        tenantInfo.setSpInvoiceNum(Integer.valueOf(sInvoiceNum));
        tenantInfo.setSpTaxAmount(sTaxAmount);
        tenantInfo.setVpInvoiceNum(Integer.valueOf(jInvoiceNum));
        tenantInfo.setVpTaxAmount(jTaxAmount);
        tenantInfo.setCtInvoiceNum(Integer.valueOf(ctInvoiceNum));
        tenantInfo.setCtTaxAmount(ctTaxAmount);
    }
}

