/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceauth.process;

import com.google.common.collect.Maps;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.repository.daoext.InvoiceDaoExt;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.service.invoice.InvoiceFilterBusiness;
import com.xforceplus.vanke.sc.base.enums.company.AuthTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceAuthEnum;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetAuthNumStatProcess
extends AbstractProcess<BaseRequest, Map<String, Integer>> {
    @Autowired
    private InvoiceFilterBusiness invoiceFilterBusiness;
    @Autowired
    private InvoiceDaoExt invoiceDaoExt;

    protected void check(BaseRequest request) throws ValidationException {
        super.check(request);
    }

    protected CommonResponse<Map<String, Integer>> process(BaseRequest request) throws RuntimeException {
        HashMap result = new HashMap(4);
        CompletableFuture<Map> elFuture = CompletableFuture.supplyAsync(() -> {
            HashMap map = Maps.newHashMap();
            Integer elCount = this.countTab(AuthTypeEnum.ELECTRONIC_ACCOUNT.getCode(), InvoiceAuthEnum.EL_AUTH.getCode());
            result.put("elCount", elCount);
            return map;
        });
        CompletableFuture<Map> smFuture = CompletableFuture.supplyAsync(() -> {
            HashMap map = Maps.newHashMap();
            Integer smCount = this.countTab(AuthTypeEnum.WEB_AUTHENTICATION.getCode(), InvoiceAuthEnum.TR_AUTH.getCode());
            result.put("smCount", smCount);
            return map;
        });
        CompletableFuture<Map> noChannelFuture = CompletableFuture.supplyAsync(() -> {
            HashMap map = Maps.newHashMap();
            Integer noChannelCount = this.countTab(AuthTypeEnum.NO_AUTHENTICATION.getCode(), InvoiceAuthEnum.NOT_CHANNEL.getCode());
            result.put("noChannelCount", noChannelCount);
            return map;
        });
        CompletableFuture<Map> inAuthFuture = CompletableFuture.supplyAsync(() -> {
            HashMap map = Maps.newHashMap();
            Integer inAuthCount = this.countTab(null, InvoiceAuthEnum.IN_AUTH.getCode());
            result.put("inAuthCount", inAuthCount);
            return map;
        });
        CompletableFuture<Map> checkExceFuture = CompletableFuture.supplyAsync(() -> {
            HashMap map = Maps.newHashMap();
            Integer checkExceCount = this.countTab(null, InvoiceAuthEnum.AUTH_ABNORMAL.getCode());
            result.put("checkExceCount", checkExceCount);
            return map;
        });
        CompletableFuture<Map> authExceFuture = CompletableFuture.supplyAsync(() -> {
            HashMap map = Maps.newHashMap();
            Integer authExceCount = this.countTab(null, InvoiceAuthEnum.COMFRIM_ABNORMAL.getCode());
            result.put("authExceCount", authExceCount);
            return map;
        });
        CompletableFuture<Void> allFuture = CompletableFuture.allOf(elFuture, smFuture, noChannelFuture, inAuthFuture, checkExceFuture, authExceFuture);
        allFuture.join();
        allFuture.thenAccept(v -> Stream.of(elFuture, smFuture, noChannelFuture, inAuthFuture, checkExceFuture, authExceFuture).forEach(r -> {
            try {
                result.putAll((Map)r.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }));
        return CommonResponse.ok((String)"\u6210\u529f", result);
    }

    private Integer countTab(Integer authType, Integer authTab) {
        WkInvoiceExample example = new WkInvoiceExample();
        WkInvoiceExample.Criteria criteria = example.createCriteria();
        this.invoiceFilterBusiness.setAuthConfigCond(authTab, criteria, null, false);
        Long count = this.invoiceDaoExt.countByCustomExample(example, authType, null, Integer.valueOf(0));
        return count.intValue();
    }
}

