/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceauth.process;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.lang.DateConvert;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.vanke.in.client.model.SendAuthRequest;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceExportBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.Message.MessageTypeEnum;
import com.xforceplus.vanke.sc.service.FileBusiness;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SendAuthExportProcess
extends AbstractProcess<SendAuthRequest, Boolean> {
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private InvoiceExportBusiness invoiceExportBusiness;
    @Autowired
    private FileBusiness fileBusiness;

    protected void check(SendAuthRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getInvoiceIds(), "\u53d1\u7968id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<Boolean> process(SendAuthRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String downloadName = "\u62b5\u6263\u52fe\u9009\u53d1\u7968\u5bfc\u51fa";
        CompletableFuture.runAsync(() -> {
            Date date = new Date();
            List entityList = this.invoiceBusiness.getInvoiceListByParams(request.getInvoiceIds(), null);
            if (CollectionUtils.isEmpty((Collection)entityList)) {
                this.invoiceExportBusiness.setEmptyMsg(downloadName, userSessionInfo);
                return;
            }
            List exportBeanList = entityList.stream().map(r -> this.invoiceExportBusiness.setInvoiceExportList(r)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(exportBeanList)) {
                this.invoiceExportBusiness.setEmptyMsg(downloadName, userSessionInfo);
                return;
            }
            List detailsExportBeanList = Lists.newArrayList();
            if (Constants.NUMBER_ONE.equals(request.getDownloadFlag())) {
                detailsExportBeanList = this.invoiceExportBusiness.getDetailExportList(entityList);
            }
            ByteArrayOutputStream baos = this.invoiceExportBusiness.uploadExcel(request.getDownloadFlag(), exportBeanList, detailsExportBeanList);
            String fileName = String.format(downloadName + "\u5bfc\u51fa_%s%s", DateHelp.dateToString((Date)new Date()), ExcelTypeEnum.XLSX.getValue());
            String exportFileUrl = this.fileBusiness.uploadFile(fileName, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
            this.logger.debug(downloadName + "\u5bfc\u51fa\u4e0a\u4f20\u5730\u5740\uff1a{}", (Object)exportFileUrl);
            String messageContent = exportFileUrl == null ? "\u5bfc\u51fa\u5931\u8d25,\u8bf7\u91cd\u8bd5!" : String.format("\u4efb\u52a1\u63d0\u4ea4\u65f6\u95f4\uff1a%s", DateUtils.toDateStr((Date)date, (String)"yyyy.MM.dd HH:mm:ss"));
            this.messageBusiness.insert(Long.valueOf(userSessionInfo.getSysUserId()), MessageTypeEnum.BUSINESS_MESSAGE.getCode().intValue(), fileName, messageContent, exportFileUrl, DateConvert.getNowDate(), Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName());
        });
        return CommonResponse.ok((String)"\u5bfc\u51fa\u6210\u529f,\u8bf7\u5728\u53f3\u4e0a\u89d2\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b!");
    }
}

