/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoicedetails.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.SaveInvoiceDetailsRequest;
import com.xforceplus.vanke.in.client.model.WkInvoiceDetailsDTO;
import com.xforceplus.vanke.in.service.invoice.InvoiceDetailsBusiness;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaveInvoiceDetailsProcess
extends AbstractProcess<SaveInvoiceDetailsRequest, List<Long>> {
    @Autowired
    private InvoiceDetailsBusiness invoiceDetailsBusiness;

    protected void check(SaveInvoiceDetailsRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        if (CollectionUtils.isEmpty((Collection)request.getEntities())) {
            throw new ValidationException("\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (WkInvoiceDetailsDTO entity : request.getEntities()) {
            this.checkEmpty((Object)entity.getInvoiceId(), "\u53d1\u7968\u4e3b\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getInvoiceCode(), "\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getInvoiceNo(), "\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getCargoName(), "\u8d27\u7269\u53ca\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getCargoCode(), "\u8d27\u7269\u53ca\u670d\u52a1\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getItemSpec(), "\u578b\u53f7\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getQuantityUnit(), "\u6570\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getQuantity(), "\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getTaxRate(), "\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getUnitPrice(), "\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getAmountWithoutTax(), "\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getTaxAmount(), "\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getAmountWithTax(), "\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getDiscountWithoutTax(), "\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getDiscountRate(), "\u6298\u6263\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getDiscountTax(), "\u6298\u6263\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getDiscountWithTax(), "\u542b\u7a0e\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getTaxItem(), "\u5546\u54c1\u7a0e\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getGoodsNoVer(), "\u7a0e\u7f16\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getGoodsTaxNo(), "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getGoodsErpNo(), "\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getPlateNumber(), "\u8f66\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getVehicleType(), "\u8f66\u8f86\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getTollStartDate(), "\u901a\u884c\u65e5\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getTollEndDate(), "\u901a\u884c\u65e5\u671f\u6b62\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getTaxPreFlag(), "\u7a0e\u6536\u4f18\u60e0\u653f\u7b56\u00a0\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getTaxPreContent(), "\u4eab\u53d7\u7a0e\u6536\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getTaxRateType(), "\u96f6\u7a0e\u7387\u6807\u5fd7\u00a0\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getTaxDedunction(), "\u6263\u9664\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getDiscountFlag(), "\u6298\u6263\u884c\u6807\u5fd7\u00a0\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getPriceMethod(), "\u4ef7\u683c\u65b9\u5f0f\u00a0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected CommonResponse<List<Long>> process(SaveInvoiceDetailsRequest request) throws RuntimeException {
        List keys = request.getEntities().stream().map(entity -> {
            int result = this.invoiceDetailsBusiness.insert(entity);
            if (result > 0) {
                return entity.getId();
            }
            return null;
        }).collect(Collectors.toList());
        if (keys.stream().anyMatch(key -> key != null)) {
            if (keys.stream().anyMatch(key -> key == null)) {
                return CommonResponse.ok((String)"\u90e8\u5206\u65b0\u589e\u6210\u529f", keys);
            }
            return CommonResponse.ok((String)"\u65b0\u589e\u6210\u529f", keys);
        }
        return CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u65b0\u589e");
    }
}

