/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.job;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.DoJobRequest;
import com.xforceplus.vanke.in.controller.job.ForcedJobProcess;
import com.xforceplus.vanke.in.repository.model.ClientEnum;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.service.job.JobBusinessApi;
import com.xforceplus.vanke.in.service.orders.OrdersBusiness;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.base.enums.common.IfAuthFlagEnum;
import com.xforceplus.vanke.sc.base.enums.common.IsLegalSynergeticsEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.DataFromSystemEnum;
import com.xforceplus.vanke.sc.base.enums.orders.OrderAuditStatusEnum;
import com.xforceplus.vanke.sc.base.exception.VankeException;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ForcedJobProcess
extends AbstractProcess<DoJobRequest, Boolean> {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private OrdersBusiness ordersBusiness;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    private final String FORCED_AUDIT_RESULT = "audit";
    private final String FORCED_AUTH_RESULT = "auth";

    protected CommonResponse<Boolean> process(DoJobRequest request) throws RuntimeException {
        String type = request.getJob();
        Integer opsType = 0;
        String opsMessage = "";
        ArrayList clientEnumList = Lists.newArrayList();
        try {
            String string;
            switch (type) {
                case "auth": {
                    opsType = OpsTypeEnum.FORCED_AUTH_RESULT.getCode();
                    this.getAuthEnum((List)clientEnumList, request);
                }
            }
            if (CollectionUtils.isEmpty((Collection)clientEnumList)) {
                string = CommonResponse.failed((String)"\u672a\u8bc6\u522b\u7684\u4efb\u52a1");
                return string;
            }
            clientEnumList.stream().forEach(clientEnum -> {
                JobBusinessApi jobBusinessApi = (JobBusinessApi)this.applicationContext.getBean(clientEnum.getClientClass());
                jobBusinessApi.pushTaskJob(request.getNoOrIds());
            });
            string = CommonResponse.ok((String)"\u6267\u884c\u6210\u529f!");
            return string;
        }
        catch (VankeException e) {
            opsMessage = e.getMessage();
            CommonResponse commonResponse = CommonResponse.failed((String)e.getMessage());
            return commonResponse;
        }
        catch (Exception e) {
            this.logger.error("\u6267\u884cjob\u5f02\u5e38! request:" + JSON.toJSONString((Object)request), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            String salesBillNo = (String)request.getNoOrIds().get(0);
            String opsName = ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserName();
            this.logOperationsBusiness.saveLogOperations(salesBillNo, opsType, opsName, opsMessage, "", "");
        }
    }

    protected void getAuditEnum(List<ClientEnum> clientEnumList, DoJobRequest request) {
        if (StringUtils.isEmpty((Object)request.getNoOrIds())) {
            return;
        }
        String systemOrign = "";
        String salesBillNo = (String)request.getNoOrIds().get(0);
        WkOrdersEntity wkOrdersEntity = this.ordersBusiness.getOrdersBySalesBillNo(salesBillNo);
        if (null == wkOrdersEntity) {
            return;
        }
        systemOrign = wkOrdersEntity.getSystemOrig();
        if (systemOrign == null) {
            return;
        }
        switch (1.$SwitchMap$com$xforceplus$vanke$sc$base$enums$invoice$DataFromSystemEnum[DataFromSystemEnum.fromCode((String)systemOrign.toUpperCase()).ordinal()]) {
            case 1: {
                clientEnumList.add(ClientEnum.fromCode((String)"SAPSettlementAuditForcedPushSync"));
            }
        }
    }

    protected void getAuthEnum(List<ClientEnum> clientEnumList, DoJobRequest request) {
        if (StringUtils.isEmpty((Object)request.getNoOrIds())) {
            return;
        }
        String systemOrign = "";
        String salesBillNo = (String)request.getNoOrIds().get(0);
        WkOrdersEntity wkOrdersEntity = this.ordersBusiness.getOrdersBySalesBillNo(salesBillNo);
        if (null == wkOrdersEntity) {
            return;
        }
        if (OrderAuditStatusEnum.SUCCESS.getCode() != wkOrdersEntity.getAuditStatus()) {
            throw new VankeException("\u8ba4\u8bc1\u72b6\u6001\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e1a\u52a1\u5355\u5ba1\u6838\u672a\u901a\u8fc7");
        }
        if (IsLegalSynergeticsEnum.YES.getCode() != wkOrdersEntity.getIsLegalSynergetics()) {
            throw new VankeException("\u8ba4\u8bc1\u72b6\u6001\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e1a\u52a1\u5355\u975e\u6cd5\u4eba\u534f\u540c");
        }
        if (IfAuthFlagEnum.YES.getCode() != wkOrdersEntity.getIfAuthFlag()) {
            throw new VankeException("\u8ba4\u8bc1\u72b6\u6001\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e1a\u52a1\u5355\u65e0\u9700\u62b5\u6263");
        }
        systemOrign = wkOrdersEntity.getSystemOrig();
        if (systemOrign == null) {
            return;
        }
        switch (1.$SwitchMap$com$xforceplus$vanke$sc$base$enums$invoice$DataFromSystemEnum[DataFromSystemEnum.fromCode((String)systemOrign.toUpperCase()).ordinal()]) {
            case 1: {
                clientEnumList.add(ClientEnum.fromCode((String)"SAPSettlementAuthForcedPushSync"));
            }
        }
    }
}

