/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.excel.EasyExcelHelp;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.vanke.in.client.model.AuditDelayCountRequest;
import com.xforceplus.vanke.in.controller.orders.process.AuditDelayCountProcess;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.in.repository.param.OrdersAuditExportParam;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.Message.MessageTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.SalsebillStatusEnum;
import com.xforceplus.vanke.sc.service.FileBusiness;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditDealyExportProcess
extends AbstractProcess<AuditDelayCountRequest, Boolean> {
    @Autowired
    private AuditDelayCountProcess auditDelayCountProcess;
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private FileBusiness fileBusiness;
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(AuditDelayCountRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<Boolean> process(AuditDelayCountRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        WkOrdersExample wkOrdersExample = this.auditDelayCountProcess.createExample(request);
        List wkOrdersEntityList = this.wkOrdersDao.selectByExample(wkOrdersExample);
        ArrayList ordersAuditExportParamList = Lists.newArrayList();
        wkOrdersEntityList.stream().forEach(ordersEntity -> {
            OrdersAuditExportParam ordersAuditExportParam = new OrdersAuditExportParam();
            BeanUtils.copyProperties((Object)ordersEntity, (Object)ordersAuditExportParam);
            SalsebillStatusEnum salsebillStatusEnum = SalsebillStatusEnum.fromValueByResource((String)ordersEntity.getStatus());
            ordersAuditExportParam.setStatus(salsebillStatusEnum == null ? "" : salsebillStatusEnum.getDesc());
            ordersAuditExportParam.setSyncTime(ordersEntity.getSyncTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)ordersEntity.getSyncTime()));
            ordersAuditExportParam.setSmSyncTime(ordersEntity.getSmSyncTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)ordersEntity.getSmSyncTime()));
            ordersAuditExportParamList.add(ordersAuditExportParam);
        });
        ByteArrayOutputStream outputStream = EasyExcelHelp.export((List)ordersAuditExportParamList, (String)"\u5ba1\u6838\u5ef6\u671f\u7edf\u8ba1", OrdersAuditExportParam.class);
        String fileName = String.format("\u5ba1\u6838\u5ef6\u671f\u7edf\u8ba1\u5bfc\u51fa_%s%s", DateUtils.curDateStr((String)"yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206"), ExcelTypeEnum.XLSX.getValue());
        String fileKey = this.fileBusiness.uploadFile(fileName, (InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        String messageCount = fileKey == null ? "\u5bfc\u51fa\u5931\u8d25,\u8bf7\u91cd\u8bd5!" : String.format("\u4efb\u52a1\u63d0\u4ea4\u65f6\u95f4\uff1a%s", DateUtils.curDateStr((String)"yyyy.MM.dd HH:mm:ss"));
        int i = this.messageBusiness.insert(Long.valueOf(userSessionInfo.getAccountId()), MessageTypeEnum.BUSINESS_MESSAGE.getCode().intValue(), fileName, messageCount, fileKey, new Date(), Long.valueOf(userSessionInfo.getAccountId()), userSessionInfo.getSysUserName());
        if (i > 0) {
            this.logger.debug("\u6dfb\u52a0\u4e0b\u8f7d\u6d88\u606f\u6210\u529f");
        }
        return CommonResponse.ok((String)"\u5bfc\u51fa\u6210\u529f,\u8bf7\u5728\u53f3\u4e0a\u89d2\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b!", (Object)true);
    }
}

