/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.AuditDelayCountRequest;
import com.xforceplus.vanke.in.client.model.WkOrdersBean;
import com.xforceplus.vanke.in.client.model.WkOrdersDTO;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.orders.OrderAuditStatusEnum;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuditDelayCountProcess
extends AbstractProcess<AuditDelayCountRequest, ListResult<WkOrdersDTO>> {
    @Autowired
    private WkOrdersDao wkOrdersDao;

    protected void check(AuditDelayCountRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<ListResult<WkOrdersDTO>> process(AuditDelayCountRequest request) throws RuntimeException {
        WkOrdersExample wkOrdersExample = this.createExample(request);
        Long count = this.wkOrdersDao.countByExample(wkOrdersExample);
        wkOrdersExample.setLimit(request.getRows());
        wkOrdersExample.setOffset(request.getOffset());
        ListResult listResult = new ListResult(count, this.wkOrdersDao.selectByExample(wkOrdersExample).stream().map(entity -> {
            WkOrdersBean dto = new WkOrdersBean();
            String smSyncTime = DateHelp.getStringTimeDiffStr((long)entity.getSmSyncTime().getTime(), (long)System.currentTimeMillis());
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            dto.setSmSyncTimeStr(smSyncTime);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
    }

    public WkOrdersExample createExample(AuditDelayCountRequest request) {
        WkOrdersExample wkOrdersExample = new WkOrdersExample();
        WkOrdersExample.Criteria criteria = wkOrdersExample.createCriteria();
        wkOrdersExample.setOrderByClause("id desc");
        if (request.getSyncTime() != null && request.getSyncTime().size() == 2) {
            criteria.andSyncTimeBetween(new Date((Long)request.getSyncTime().get(0)), new Date((Long)request.getSyncTime().get(1)));
        }
        if (request.getSmSyncTime() != null && request.getSmSyncTime().size() == 2) {
            criteria.andSmSyncTimeBetween(new Date((Long)request.getSmSyncTime().get(0)), new Date((Long)request.getSmSyncTime().get(1)));
        }
        if (!CollectionUtils.isEmpty((Collection)request.getSystemOrig())) {
            criteria.andSystemOrigIn(request.getSystemOrig());
        }
        if (!StringHelp.safeIsEmpty((Object)request.getPurchaserName())) {
            criteria.andPurchaserNameLike(request.getPurchaserName() + "%");
        }
        if (!StringHelp.safeIsEmpty((Object)request.getSalesbillNo())) {
            criteria.andSalesbillNoEqualTo(request.getSalesbillNo());
        }
        if (!CollectionUtils.isEmpty((Collection)request.getStatus())) {
            criteria.andStatusIn(request.getStatus());
        }
        if (ValidatorUtil.isNotEmpty((Object)request.getCooperateFlag())) {
            criteria.andCooperateFlagEqualTo(request.getCooperateFlag());
        }
        criteria.andSmSyncTimeNotEqualTo(new Date(Constants.DEFAULT_TIME));
        criteria.andAuditStatusEqualTo(OrderAuditStatusEnum.NOT_AUDIT.getCode());
        criteria.andStatusEqualTo("Y");
        return wkOrdersExample;
    }
}

