/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.OrdersBaseRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkOrderInvoiceRelationDao;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.repository.model.WkOrderInvoiceRelationExample;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.jc.JcBusiness;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.base.enums.IsOrNo;
import com.xforceplus.vanke.sc.base.enums.invoice.StatusEnum;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CancelOrderProcess
extends AbstractProcess<OrdersBaseRequest, Boolean> {
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private JcBusiness jcBusiness;
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private WkOrderInvoiceRelationDao wkOrderInvoiceRelationDao;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(OrdersBaseRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getSalesbillNo(), "\u4e1a\u52a1\u5355\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    protected CommonResponse<Boolean> process(OrdersBaseRequest request) throws RuntimeException {
        JSONObject syncAbandonOrDelete;
        List invoices = this.invoiceBusiness.getInvoiceListBySalesbillNo(request.getSalesbillNo(), false);
        if (invoices != null && !invoices.isEmpty()) {
            JSONObject associateCancelBill = this.jcBusiness.associateCancelBill(request.getSalesbillNo());
            if (1 != associateCancelBill.getIntValue("code")) {
                return CommonResponse.failed((String)associateCancelBill.getString("message"));
            }
            WkInvoiceExample example = new WkInvoiceExample();
            WkInvoiceExample.Criteria criteria1 = example.createCriteria();
            criteria1.andSalesbillNoEqualTo(request.getSalesbillNo());
            WkInvoiceEntity update = new WkInvoiceEntity();
            update.setSalesbillNo("");
            update.setSalesbillId(Long.valueOf(0L));
            update.setIsLegalSynergetics(IsOrNo.NO.getCode());
            update.setIfAuthFlag(IsOrNo.NO.getCode());
            update.setDataFromSystem("");
            update.setCooperateFlag(IsOrNo.NO.getCode());
            this.wkInvoiceDao.updateByExampleSelective(update, example);
            WkOrderInvoiceRelationExample deleteExample = new WkOrderInvoiceRelationExample();
            deleteExample.createCriteria().andSalesbillNoEqualTo(request.getSalesbillNo());
            this.wkOrderInvoiceRelationDao.deleteByExample(deleteExample);
        }
        if (1 != (syncAbandonOrDelete = this.jcBusiness.syncAbandonOrDelete(request.getSalesbillNo())).getIntValue("code")) {
            return CommonResponse.failed((String)syncAbandonOrDelete.getString("message"));
        }
        WkOrdersEntity wkOrdersEntity = new WkOrdersEntity();
        wkOrdersEntity.setStatus(StatusEnum.OBSOLETE.getCode());
        wkOrdersEntity.setCreateTime(new Date());
        WkOrdersExample wkOrdersUpdate = new WkOrdersExample();
        wkOrdersUpdate.createCriteria().andSalesbillNoEqualTo(request.getSalesbillNo());
        this.wkOrdersDao.updateByExampleSelective(wkOrdersEntity, wkOrdersUpdate);
        this.logOperationsBusiness.saveLogOperations(request.getSalesbillNo(), OpsTypeEnum.ORDERS_CANCEL.getCode(), ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserName(), "", "", "");
        return CommonResponse.ok((String)"\u8c03\u7528\u6210\u529f!");
    }
}

