/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.GetOrderStatusLifeCycleRequest;
import com.xforceplus.vanke.in.client.model.WkOrdersLifecycleDTO;
import com.xforceplus.vanke.in.repository.dao.WkOrdersLifecycleDao;
import com.xforceplus.vanke.in.repository.model.WkOrdersLifecycleExample;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.CommonTools;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetOrderLifeCycleProcess
extends AbstractProcess<GetOrderStatusLifeCycleRequest, ListResult<WkOrdersLifecycleDTO>> {
    @Autowired
    private WkOrdersLifecycleDao wkOrdersLifecycleDao;

    protected void check(GetOrderStatusLifeCycleRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<ListResult<WkOrdersLifecycleDTO>> process(GetOrderStatusLifeCycleRequest request) throws RuntimeException {
        WkOrdersLifecycleExample example = this.createExample(request);
        Long count = this.wkOrdersLifecycleDao.countByExample(example);
        example.setLimit(request.getRows());
        example.setOffset(request.getOffset());
        ListResult listResult = new ListResult(count, this.wkOrdersLifecycleDao.selectByExample(example).stream().map(entity -> {
            WkOrdersLifecycleDTO dto = new WkOrdersLifecycleDTO();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
    }

    public WkOrdersLifecycleExample createExample(GetOrderStatusLifeCycleRequest request) {
        WkOrdersLifecycleExample wkOrdersLifecycleExample = new WkOrdersLifecycleExample();
        WkOrdersLifecycleExample.Criteria criteria = wkOrdersLifecycleExample.createCriteria();
        wkOrdersLifecycleExample.setOrderByClause("create_time desc");
        if (!CollectionUtils.isEmpty((Collection)request.getSystemOrig())) {
            criteria.andSystemOrigIn(request.getSystemOrig());
        }
        if (!CollectionUtils.isEmpty((Collection)request.getIsCooperate())) {
            criteria.andCooperateFlagIn(request.getIsCooperate());
        }
        if (!StringHelp.safeIsEmpty((Object)request.getSalesbillNo())) {
            criteria.andSalesbillNoLike(request.getSalesbillNo());
        }
        if (!StringHelp.safeIsEmpty((Object)request.getPurchaserName())) {
            criteria.andPurchaserNameLike(request.getPurchaserName() + "%");
        }
        if (!CollectionUtils.isEmpty((Collection)request.getIfAuthFlag())) {
            criteria.andIfAuthFlagIn(request.getIfAuthFlag());
        }
        if (request.getSignTime() != null && request.getSignTime().size() == 2) {
            criteria.andSignEndTimeBetween(new Date((Long)request.getSignTime().get(0)), new Date((Long)request.getSignTime().get(1)));
        }
        if (request.getSmSyncTime() != null && request.getSmSyncTime().size() == 2) {
            criteria.andSmEndTimeBetween(new Date((Long)request.getSmSyncTime().get(0)), new Date((Long)request.getSmSyncTime().get(1)));
        }
        if (request.getAuditUpdateTime() != null && request.getAuditUpdateTime().size() == 2) {
            criteria.andAuditEndTimeBetween(new Date((Long)request.getAuditUpdateTime().get(0)), new Date((Long)request.getAuditUpdateTime().get(1)));
        }
        if (request.getAuthUpdateTime() != null && request.getAuthUpdateTime().size() == 2) {
            criteria.andAuthEndTimeBetween(new Date((Long)request.getAuthUpdateTime().get(0)), new Date((Long)request.getAuthUpdateTime().get(1)));
        }
        if (request.getErrorFlag() != null) {
            criteria.andErrorFlagEqualTo(request.getErrorFlag());
        }
        if (!CommonTools.isEmpty((List)request.getSalesbillStatus())) {
            criteria.andSalesbillStatusIn(request.getSalesbillStatus());
        }
        if (request.getIsFinish() != null) {
            criteria.andIsFinishEqualTo(request.getIsFinish());
        }
        if (request.getIsOverdue() != null) {
            criteria.andIsOverdueEqualTo(request.getIsOverdue());
        }
        if (request.getIsMonitoring() != null) {
            criteria.andIsMonitoringEqualTo(request.getIsMonitoring());
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getCreateTime()) && request.getCreateTime().size() == 2) {
            criteria.andCreateTimeBetween(new Date((Long)request.getCreateTime().get(0)), new Date((Long)request.getCreateTime().get(1)));
        }
        return wkOrdersLifecycleExample;
    }
}

