/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.GetOrderStatusLifeCycleRequest;
import com.xforceplus.vanke.in.client.model.WkOrdersBean;
import com.xforceplus.vanke.in.client.model.WkOrdersDTO;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetOrderStatusLifeCycleProcess
extends AbstractProcess<GetOrderStatusLifeCycleRequest, ListResult<WkOrdersDTO>> {
    @Autowired
    private WkOrdersDao wkOrdersDao;

    protected void check(GetOrderStatusLifeCycleRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<ListResult<WkOrdersDTO>> process(GetOrderStatusLifeCycleRequest request) throws RuntimeException {
        WkOrdersExample wkOrdersExample = this.createExample(request);
        Long count = this.wkOrdersDao.countByExample(wkOrdersExample);
        wkOrdersExample.setLimit(request.getRows());
        wkOrdersExample.setOffset(request.getOffset());
        ListResult listResult = new ListResult(count, this.wkOrdersDao.selectByExample(wkOrdersExample).stream().map(entity -> {
            WkOrdersBean dto = new WkOrdersBean();
            String issueTime = DateHelp.getStringTimeDiffAndNegativeStr((long)entity.getSellerDrawDate().getTime(), (long)entity.getPostcodeSignTime().getTime());
            String postCodeTime = DateHelp.getStringTimeDiffAndNegativeStr((long)entity.getPostcodeSignTime().getTime(), (long)entity.getSignTime().getTime());
            String invoiceSignTime = DateHelp.getStringTimeDiffAndNegativeStr((long)entity.getPostcodeSignTime().getTime(), (long)entity.getSmSyncTime().getTime());
            String auditTime = DateHelp.getStringTimeDiffAndNegativeStr((long)entity.getAuditUpdateTime().getTime(), (long)entity.getAuthUpdateTime().getTime());
            String smSyncTimeStr = DateHelp.getStringTimeDiffAndNegativeStr((long)entity.getSmSyncTime().getTime(), (long)entity.getAuditUpdateTime().getTime());
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            dto.setIssueTimeStr(issueTime);
            dto.setPostCodeTimeStr(postCodeTime);
            dto.setInvoiceSignTimeStr(invoiceSignTime);
            dto.setAuditTimeStr(auditTime);
            dto.setSmSyncTimeStr(smSyncTimeStr);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
    }

    public WkOrdersExample createExample(GetOrderStatusLifeCycleRequest request) {
        WkOrdersExample wkOrdersExample = new WkOrdersExample();
        WkOrdersExample.Criteria criteria = wkOrdersExample.createCriteria();
        wkOrdersExample.setOrderByClause("create_time desc");
        if (!CollectionUtils.isEmpty((Collection)request.getSystemOrig())) {
            criteria.andSystemOrigIn(request.getSystemOrig());
        }
        if (!CollectionUtils.isEmpty((Collection)request.getIsCooperate())) {
            criteria.andCooperateFlagIn(request.getIsCooperate());
        }
        if (!StringHelp.safeIsEmpty((Object)request.getSalesbillNo())) {
            criteria.andSalesbillNoLike(request.getSalesbillNo());
        }
        if (!StringHelp.safeIsEmpty((Object)request.getPurchaserName())) {
            criteria.andPurchaserNameLike(request.getPurchaserName() + "%");
        }
        if (!CollectionUtils.isEmpty((Collection)request.getIfAuthFlag())) {
            criteria.andIfAuthFlagIn(request.getIfAuthFlag());
        }
        if (request.getSignTime() != null && request.getSignTime().size() == 2) {
            criteria.andSignTimeBetween(new Date((Long)request.getSignTime().get(0)), new Date((Long)request.getSignTime().get(1)));
        }
        if (request.getSmSyncTime() != null && request.getSmSyncTime().size() == 2) {
            criteria.andSmSyncTimeBetween(new Date((Long)request.getSmSyncTime().get(0)), new Date((Long)request.getSmSyncTime().get(1)));
        }
        if (request.getAuditUpdateTime() != null && request.getAuditUpdateTime().size() == 2) {
            criteria.andAuditUpdateTimeBetween(new Date((Long)request.getAuditUpdateTime().get(0)), new Date((Long)request.getAuditUpdateTime().get(1)));
        }
        if (request.getAuthUpdateTime() != null && request.getAuthUpdateTime().size() == 2) {
            criteria.andAuthUpdateTimeBetween(new Date((Long)request.getAuthUpdateTime().get(0)), new Date((Long)request.getAuthUpdateTime().get(1)));
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getCreateTime()) && request.getCreateTime().size() == 2) {
            criteria.andCreateTimeBetween(new Date((Long)request.getCreateTime().get(0)), new Date((Long)request.getCreateTime().get(1)));
        }
        return wkOrdersExample;
    }
}

