/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.ModifyAuditStatusRequest;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.in.service.jc.JcBusiness;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.base.enums.orders.OrderAuditStatusEnum;
import com.xforceplus.vanke.sc.base.enums.orders.OrdersBlockadeEnum;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import java.util.Date;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModifyAuditStatusProcess
extends AbstractProcess<ModifyAuditStatusRequest, Boolean> {
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private JcBusiness jcBusiness;

    protected void check(ModifyAuditStatusRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getSalesbillNo(), "\u4e1a\u52a1\u5355\u4e0d\u80fd\u4e3a\u7a7a!");
        this.checkEmpty((Object)request.getAuditStatus(), "\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        OrderAuditStatusEnum orderAuditStatusEnum = OrderAuditStatusEnum.fromCode((Integer)request.getAuditStatus());
        if (null == orderAuditStatusEnum || OrderAuditStatusEnum.FAILED.getCode().equals(orderAuditStatusEnum.getCode())) {
            throw new ValidationException("\u5ba1\u6838\u72b6\u6001\u6709\u8bef!");
        }
    }

    protected CommonResponse<Boolean> process(ModifyAuditStatusRequest request) throws RuntimeException {
        String salesbillNo = request.getSalesbillNo();
        Integer auditStatus = request.getAuditStatus();
        WkOrdersEntity ordersEntity = new WkOrdersEntity();
        String message = "";
        if (OrderAuditStatusEnum.NOT_AUDIT.getCode().equals(auditStatus)) {
            ordersEntity.setAuditStatus(OrderAuditStatusEnum.SUCCESS.getCode());
            ordersEntity.setAuditUpdateTime(new Date());
            message = "\u672a\u5ba1\u6838\u4fee\u6539\u4e3a\u5ba1\u6838\u6210\u529f";
            this.jcBusiness.invoiceBlockade(salesbillNo, OrdersBlockadeEnum.BLOCKADE.getCode().intValue(), ordersEntity);
        } else if (OrderAuditStatusEnum.SUCCESS.getCode().equals(auditStatus)) {
            ordersEntity.setAuditStatus(OrderAuditStatusEnum.NOT_AUDIT.getCode());
            message = "\u5ba1\u6838\u6210\u529f\u4fee\u6539\u4e3a\u672a\u5ba1\u6838";
            this.jcBusiness.invoiceBlockade(salesbillNo, OrdersBlockadeEnum.UNLOCK.getCode().intValue(), ordersEntity);
        }
        WkOrdersExample wkOrdersExample = new WkOrdersExample();
        wkOrdersExample.createCriteria().andSalesbillNoEqualTo(salesbillNo);
        this.wkOrdersDao.updateByExampleSelective(ordersEntity, wkOrdersExample);
        this.logOperationsBusiness.saveLogOperations(salesbillNo, OpsTypeEnum.MODIFY_AUDIT.getCode(), ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserName(), message, "", "");
        return CommonResponse.ok((String)"\u6210\u529f");
    }
}

