/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.ModifyLegalSynergeticsRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.in.service.jc.JcBusiness;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.base.enums.IsOrNo;
import com.xforceplus.vanke.sc.base.enums.invoice.SyncJcFlagEnum;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModifyLegalSynergeticsProcess
extends AbstractProcess<ModifyLegalSynergeticsRequest, Boolean> {
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private JcBusiness jcBusiness;

    protected void check(ModifyLegalSynergeticsRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getSalesbillNo(), "\u4e1a\u52a1\u5355\u4e0d\u80fd\u4e3a\u7a7a!");
        this.checkEmpty((Object)request.getIsLegalSynergetics(), "\u662f\u5426\u6cd5\u4eba\u534f\u540c\u4e0d\u80fd\u4e3a\u7a7a!");
        IsOrNo isLegalSynergeticsEnum = IsOrNo.fromCode((Integer)request.getIsLegalSynergetics());
        if (null == isLegalSynergeticsEnum) {
            throw new ValidationException("\u662f\u5426\u6cd5\u4eba\u534f\u540c\u6709\u8bef!");
        }
    }

    protected CommonResponse<Boolean> process(ModifyLegalSynergeticsRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        IsOrNo isLegalSynergeticsEnum = IsOrNo.fromCode((Integer)request.getIsLegalSynergetics());
        String message = "\u4fee\u6539\u6cd5\u4eba\u534f\u540c\u4e3a" + isLegalSynergeticsEnum.getName();
        WkOrdersEntity ordersEntity = new WkOrdersEntity();
        ordersEntity.setIsLegalSynergetics(request.getIsLegalSynergetics());
        WkOrdersExample wkOrdersExample = new WkOrdersExample();
        wkOrdersExample.createCriteria().andSalesbillNoEqualTo(request.getSalesbillNo());
        this.wkOrdersDao.updateByExampleSelective(ordersEntity, wkOrdersExample);
        WkInvoiceEntity invoiceEntity = new WkInvoiceEntity();
        invoiceEntity.setIsLegalSynergetics(request.getIsLegalSynergetics());
        WkInvoiceExample wkInvoiceExample = new WkInvoiceExample();
        wkInvoiceExample.createCriteria().andSalesbillNoEqualTo(request.getSalesbillNo());
        this.wkInvoiceDao.updateByExampleSelective(invoiceEntity, wkInvoiceExample);
        this.jcBusiness.syncInvoiceTOMqByOrder(request.getSalesbillNo(), SyncJcFlagEnum.LEGAL_SYNERGETICS.getCode());
        this.logOperationsBusiness.saveLogOperations(request.getSalesbillNo(), OpsTypeEnum.MODIFY_LEGAL_SYNERGETICS.getCode(), userSessionInfo.getSysUserName(), message, "", "");
        return CommonResponse.ok((String)"\u6210\u529f");
    }
}

