/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.MonitoringCancelRequest;
import com.xforceplus.vanke.in.repository.dao.WkOrdersLifecycleDao;
import com.xforceplus.vanke.in.repository.model.WkOrdersLifecycleEntity;
import com.xforceplus.vanke.in.repository.model.WkOrdersLifecycleExample;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import java.util.Date;
import javax.validation.ValidationException;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitoringCancelProcess
extends AbstractProcess<MonitoringCancelRequest, Boolean> {
    @Autowired
    private WkOrdersLifecycleDao wkOrdersLifecycleDao;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(MonitoringCancelRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<Boolean> process(MonitoringCancelRequest request) throws RuntimeException {
        if (Strings.isBlank((String)request.getSalesbillNo())) {
            return CommonResponse.failed((String)"\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isBlank((String)request.getInfo())) {
            return CommonResponse.failed((String)"\u53d6\u6d88\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WkOrdersLifecycleExample example = new WkOrdersLifecycleExample();
        example.createCriteria().andSalesbillNoEqualTo(request.getSalesbillNo());
        WkOrdersLifecycleEntity wkOrdersLifecycleEntity = new WkOrdersLifecycleEntity();
        wkOrdersLifecycleEntity.setIsMonitoring(Integer.valueOf(0));
        wkOrdersLifecycleEntity.setMonitoringCancelInfo(request.getInfo());
        wkOrdersLifecycleEntity.setUpdateTime(new Date());
        this.wkOrdersLifecycleDao.updateByExampleSelective(wkOrdersLifecycleEntity, example);
        String opsName = ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserName();
        this.logOperationsBusiness.saveLogOperations(request.getSalesbillNo(), OpsTypeEnum.MONITORING_CANCEL.getCode(), opsName, request.getInfo(), "", "");
        return CommonResponse.ok((String)"\u4fee\u6539\u6210\u529f");
    }
}

