/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.ModifyLegalSynergeticsRequest;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.sync.SmInvoiceSyncDeal;
import com.xforceplus.vanke.in.service.orders.OrdersBusiness;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.RecogStatusEnum;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PushSyncImagesForGXProcess
extends AbstractProcess<ModifyLegalSynergeticsRequest, Boolean> {
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private OrdersBusiness ordersBusiness;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private SmInvoiceSyncDeal smInvoiceSyncDeal;

    protected void check(ModifyLegalSynergeticsRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getSalesbillNo(), "\u4e1a\u52a1\u5355\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    protected CommonResponse<Boolean> process(ModifyLegalSynergeticsRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        List ordersEntityList = this.ordersBusiness.selectBySelect(request.getSalesbillNo(), null);
        if (CollectionUtils.isEmpty((Collection)ordersEntityList)) {
            return CommonResponse.failed((String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5355\u6570\u636e");
        }
        WkOrdersEntity ordersEntity = (WkOrdersEntity)ordersEntityList.get(0);
        if (StringHelp.safeIsEmpty((Object)ordersEntity.getReserve1())) {
            return CommonResponse.failed((String)"\u534f\u540c\u63a8\u9001\u5f71\u50cf\u6570\u636e\u626b\u63cf\u6279\u6b21\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63a8\u9001");
        }
        List invoiceList = this.invoiceBusiness.getInvoiceListForNored(request.getSalesbillNo(), true);
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            return CommonResponse.failed((String)"\u4e1a\u52a1\u5355\u4e0b\u672a\u67e5\u8be2\u5230\u53d1\u7968");
        }
        ArrayList tempList = Lists.newArrayList();
        invoiceList.stream().filter(r -> RecogStatusEnum.RECOG_OK.getCode().equals(r.getRecogStatus())).forEach(r -> {
            if (StringHelp.safeIsEmpty((Object)r.getRecogInvoiceImageUrl()) && StringHelp.safeIsEmpty((Object)r.getRecogDeductionImageUrl())) {
                WkInvoiceEntity updateInvoiceEntity = new WkInvoiceEntity();
                String imgUrl = String.format("https://vat.servingcloud.com/wims/api/invoiceScan?invoiceCode=%s&invoiceNo=%s", r.getInvoiceCode(), r.getInvoiceNo());
                r.setRecogInvoiceImageUrl(imgUrl);
                updateInvoiceEntity.setRecogInvoiceImageUrl(imgUrl);
                updateInvoiceEntity.setId(r.getId());
                this.invoiceBusiness.updateInvoiceSelect(updateInvoiceEntity);
            }
            tempList.add(r);
        });
        if (CollectionUtils.isEmpty((Collection)tempList)) {
            return CommonResponse.failed((String)"\u4e1a\u52a1\u5355\u4e0b\u53d1\u7968\u65e0\u5f71\u50cf\u5730\u5740\uff0c\u65e0\u6cd5\u63a8\u9001");
        }
        this.smInvoiceSyncDeal.executePushImageForGx(ordersEntity, invoiceList);
        this.logOperationsBusiness.saveLogOperations(request.getSalesbillNo(), OpsTypeEnum.PUSH_SYNC_IMAGE_GX.getCode(), userSessionInfo.getSysUserName(), "\u63a8\u9001\u534f\u540c\u5f71\u50cf\u81f3\u56fd\u4fe1\u7cfb\u7edf", "", "");
        return CommonResponse.ok((String)"\u6210\u529f");
    }
}

