/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.parcel.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.in.client.model.GetParcelListRequest;
import com.xforceplus.vanke.in.client.model.WkParcelDTO;
import com.xforceplus.vanke.in.repository.dao.WkParcelDao;
import com.xforceplus.vanke.in.repository.model.WkParcelExample;
import com.xforceplus.vanke.in.service.parcel.ParcelFilterBusiness;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetParcelListProcess
extends AbstractProcess<GetParcelListRequest, ListResult<WkParcelDTO>> {
    @Autowired
    private WkParcelDao wkParcelDao;
    @Autowired
    private ParcelFilterBusiness parcelFilterBusiness;

    protected void check(GetParcelListRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getBusinessLgtStatus(), "tab\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty((Object)request.getSenderRole(), "\u5bc4\u9001\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<ListResult<WkParcelDTO>> process(GetParcelListRequest request) throws RuntimeException {
        WkParcelExample example = new WkParcelExample();
        WkParcelExample.Criteria criteria = example.createCriteria();
        this.parcelFilterBusiness.setParcelFilterExample(criteria, request);
        long count = this.wkParcelDao.countByExample(example);
        example.setLimit(request.getRows());
        example.setOffset(request.getOffset());
        this.parcelFilterBusiness.setParcelOrder(example, request.getOrderNum());
        ListResult listResult = new ListResult(Long.valueOf(count), this.wkParcelDao.selectByExample(example).stream().map(entity -> {
            WkParcelDTO dto = new WkParcelDTO();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
    }
}

