/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.parcel.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.ModifyWaybillNoRequest;
import com.xforceplus.vanke.in.repository.dao.WkParcelDao;
import com.xforceplus.vanke.in.repository.model.WkParcelEntity;
import com.xforceplus.vanke.in.service.parcel.ParcelBusiness;
import com.xforceplus.vanke.in.service.parcel.ParcelDetailsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModifyWaybillNoProcess
extends AbstractProcess<ModifyWaybillNoRequest, Boolean> {
    @Autowired
    private ParcelBusiness parcelBusiness;
    @Autowired
    private ParcelDetailsBusiness parcelDetailsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private WkParcelDao wkParcelDao;

    protected void check(ModifyWaybillNoRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getParcelId(), "\u5305\u88f9id\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getGoodsIds(), "\u5305\u88f9\u7269\u54c1id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getWaybillNo(), "\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getExpressCode(), "\u5feb\u9012\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Boolean> process(ModifyWaybillNoRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List existParcel = this.parcelBusiness.selectInfoByWaybillNo(request.getWaybillNo(), request.getExpressCode());
        if (!CollectionUtils.isEmpty((Collection)existParcel)) {
            this.parcelDetailsBusiness.updateNewWaybill((WkParcelEntity)existParcel.get(0), request.getGoodsIds());
        } else {
            WkParcelEntity orgParcel = this.wkParcelDao.selectByPrimaryKey(request.getParcelId());
            if (null == orgParcel) {
                return CommonResponse.failed((String)"\u672a\u67e5\u5230\u5305\u88f9\u4fe1\u606f.");
            }
            Long parcelId = this.parcelBusiness.setParcelEntity(orgParcel, request.getWaybillNo(), request.getExpressCode(), request.getExpressName(), userSessionInfo);
            if (null == parcelId) {
                return CommonResponse.failed((String)"\u8fd0\u5355\u53f7\u4fee\u6539\u5931\u8d25.");
            }
            this.parcelDetailsBusiness.updateInvoiceSendInfo(parcelId, userSessionInfo, request.getGoodsIds());
        }
        List allDetail = this.parcelDetailsBusiness.selectInfoByParcelId(request.getParcelId());
        if (CollectionUtils.isEmpty((Collection)allDetail)) {
            this.wkParcelDao.deleteByPrimaryKey(request.getParcelId());
        }
        return CommonResponse.ok((String)"\u8fd0\u5355\u53f7\u4fee\u6539\u6210\u529f.");
    }
}

