/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.parceldetails.process;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.excel.EasyExcelHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.vanke.in.client.model.GetParcelDetailsListRequest;
import com.xforceplus.vanke.in.repository.dao.WkParcelDao;
import com.xforceplus.vanke.in.repository.dao.WkParcelDetailsDao;
import com.xforceplus.vanke.in.repository.model.WkParcelDetailsEntity;
import com.xforceplus.vanke.in.repository.model.WkParcelDetailsExample;
import com.xforceplus.vanke.in.repository.model.WkParcelEntity;
import com.xforceplus.vanke.in.repository.model.WkParcelExample;
import com.xforceplus.vanke.in.repository.param.WkParcelDetailsParam;
import com.xforceplus.vanke.in.service.parcel.ParcelFilterBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.LogisticsStatus.LogisticsExpressCodeEnum;
import com.xforceplus.vanke.sc.base.enums.Message.MessageTypeEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.InvoiceSheetEnum;
import com.xforceplus.vanke.sc.service.FileBusiness;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatdata.base.BaseEntity;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportBackInvoiceProcess
extends AbstractProcess<GetParcelDetailsListRequest, Boolean> {
    @Autowired
    private WkParcelDetailsDao wkParcelDetailsDao;
    @Autowired
    private ParcelFilterBusiness parcelFilterBusiness;
    @Autowired
    private WkParcelDao wkParcelDao;
    @Autowired
    private FileBusiness fileBusiness;
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected CommonResponse<Boolean> process(GetParcelDetailsListRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        CompletableFuture.runAsync(() -> {
            try {
                List list = this.getExcelList(request);
                ByteArrayOutputStream baos = EasyExcelHelp.export((List)list, (String)"\u9000\u7968\u62a5\u8868", WkParcelDetailsParam.class);
                String fileName = String.format("\u9000\u7968\u7269\u6d41\u6570\u636e\u4e0b\u8f7d_%s%s", DateUtils.curDateStr((String)"yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206"), ExcelTypeEnum.XLSX.getValue());
                String fileKey = this.fileBusiness.uploadFile(fileName, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
                String messageCount = fileKey == null ? "\u5bfc\u51fa\u5931\u8d25,\u8bf7\u91cd\u8bd5!" : String.format("\u4efb\u52a1\u63d0\u4ea4\u65f6\u95f4\uff1a%s", DateUtils.curDateStr((String)"yyyy.MM.dd HH:mm:ss"));
                int i = this.messageBusiness.insert(Long.valueOf(userSessionInfo.getAccountId()), MessageTypeEnum.BUSINESS_MESSAGE.getCode().intValue(), fileName, messageCount, fileKey, new Date(), Long.valueOf(userSessionInfo.getAccountId()), userSessionInfo.getSysUserName());
                if (i > 0) {
                    this.logger.debug("\u6dfb\u52a0\u4e0b\u8f7d\u6d88\u606f\u6210\u529f");
                }
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            }
        });
        return CommonResponse.ok((String)"\u6210\u529f", (Object)true);
    }

    private List<WkParcelDetailsParam> getExcelList(GetParcelDetailsListRequest request) {
        WkParcelDetailsExample example = new WkParcelDetailsExample();
        WkParcelDetailsExample.Criteria criteria = example.createCriteria();
        this.parcelFilterBusiness.setParcelDetailsFilterExample(criteria, request);
        example.setOrderByClause("create_time desc,invoice_no asc");
        List detailsEntities = this.wkParcelDetailsDao.selectByExample(example);
        List parcelIds = detailsEntities.stream().map(WkParcelDetailsEntity::getParcelId).distinct().collect(Collectors.toList());
        if (parcelIds.isEmpty()) {
            return new ArrayList<WkParcelDetailsParam>();
        }
        WkParcelExample parcelExample = new WkParcelExample();
        parcelExample.createCriteria().andIdIn(parcelIds);
        List parcelEntities = this.wkParcelDao.selectByExample(parcelExample);
        if (parcelEntities.isEmpty()) {
            return new ArrayList<WkParcelDetailsParam>();
        }
        Map parcelMap = parcelEntities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        return detailsEntities.stream().map(entity -> {
            WkParcelDetailsParam param = new WkParcelDetailsParam();
            BeanUtils.copyProperties((Object)entity, (Object)param);
            param.setReceiverCompany(entity.getReceiverCompanyName());
            InvoiceSheetEnum invoiceSheetEnum = InvoiceSheetEnum.fromCode((Integer)entity.getInvoiceSheet());
            String invoiceSheet = invoiceSheetEnum != null ? invoiceSheetEnum.getName() : "";
            param.setInvoiceSheet(invoiceSheet);
            WkParcelEntity parcelEntity = (WkParcelEntity)parcelMap.get(entity.getParcelId());
            if (parcelEntity == null) {
                return param;
            }
            LogisticsExpressCodeEnum expressCodeEnum = LogisticsExpressCodeEnum.fromCode((String)parcelEntity.getExpressCode());
            String expressCode = expressCodeEnum != null ? expressCodeEnum.getName() : "";
            param.setExpressCode(expressCode);
            param.setWaybillNo(parcelEntity.getWaybillNo());
            param.setReceiverName(parcelEntity.getReceiverName());
            param.setSenderTime(this.displayTime(parcelEntity.getSenderTime()));
            param.setSenderName(parcelEntity.getSenderName());
            return param;
        }).collect(Collectors.toList());
    }

    private String displayTime(Date date) {
        Date nullDate = new Date(Constants.DEFAULT_TIME);
        if (nullDate.equals(date)) {
            return "-";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }
}

