/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.parceldetails.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.in.client.model.GetParcelDetailsListRequest;
import com.xforceplus.vanke.in.client.model.WkParcelDetailsBean;
import com.xforceplus.vanke.in.client.model.WkParcelDetailsDTO;
import com.xforceplus.vanke.in.repository.dao.WkExceptionDao;
import com.xforceplus.vanke.in.repository.dao.WkParcelDao;
import com.xforceplus.vanke.in.repository.dao.WkParcelDetailsDao;
import com.xforceplus.vanke.in.repository.model.WkExceptionEntity;
import com.xforceplus.vanke.in.repository.model.WkExceptionExample;
import com.xforceplus.vanke.in.repository.model.WkParcelDetailsExample;
import com.xforceplus.vanke.in.repository.model.WkParcelEntity;
import com.xforceplus.vanke.in.repository.model.WkParcelExample;
import com.xforceplus.vanke.in.service.parcel.ParcelFilterBusiness;
import com.xforceplus.xplatdata.base.BaseEntity;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetParcelDetailsListProcess
extends AbstractProcess<GetParcelDetailsListRequest, ListResult<WkParcelDetailsBean>> {
    @Autowired
    private WkParcelDetailsDao wkParcelDetailsDao;
    @Autowired
    private ParcelFilterBusiness parcelFilterBusiness;
    @Autowired
    private WkExceptionDao wkExceptionDao;
    @Autowired
    private WkParcelDao wkParcelDao;

    protected void check(GetParcelDetailsListRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<ListResult<WkParcelDetailsBean>> process(GetParcelDetailsListRequest request) throws RuntimeException {
        WkParcelDetailsExample example = new WkParcelDetailsExample();
        WkParcelDetailsExample.Criteria criteria = example.createCriteria();
        this.parcelFilterBusiness.setParcelDetailsFilterExample(criteria, request);
        long count = this.wkParcelDetailsDao.countByExample(example);
        example.setLimit(request.getRows());
        example.setOffset(request.getOffset());
        this.parcelFilterBusiness.setParcelDetailsOrder(example, request.getOrderNum());
        ListResult listResult = new ListResult(Long.valueOf(count), this.wkParcelDetailsDao.selectByExample(example).stream().map(entity -> {
            WkParcelDetailsBean dto = new WkParcelDetailsBean();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        List exceptionIds = listResult.getList().stream().map(WkParcelDetailsDTO::getGoodsId).distinct().collect(Collectors.toList());
        if (exceptionIds.isEmpty()) {
            return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
        }
        WkExceptionExample exceptionExample = new WkExceptionExample();
        exceptionExample.createCriteria().andIdIn(exceptionIds);
        List exceptionEntities = this.wkExceptionDao.selectByExample(exceptionExample);
        if (exceptionEntities.isEmpty()) {
            return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
        }
        Map exceptionMap = exceptionEntities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        listResult.getList().forEach(bean -> {
            WkExceptionEntity exceptionEntity = (WkExceptionEntity)exceptionMap.get(bean.getGoodsId());
            if (exceptionEntity == null) {
                return;
            }
            bean.setReturnBatch(exceptionEntity.getReturnBatch());
            bean.setReturnType(exceptionEntity.getReturnType());
        });
        List parcelIds = listResult.getList().stream().map(WkParcelDetailsDTO::getParcelId).distinct().collect(Collectors.toList());
        if (parcelIds.isEmpty()) {
            return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
        }
        WkParcelExample parcelExample = new WkParcelExample();
        parcelExample.createCriteria().andIdIn(parcelIds);
        List parcelEntities = this.wkParcelDao.selectByExample(parcelExample);
        if (parcelEntities.isEmpty()) {
            return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
        }
        Map parcelMap = parcelEntities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        listResult.getList().forEach(bean -> {
            WkParcelEntity parcelEntity = (WkParcelEntity)parcelMap.get(bean.getParcelId());
            if (parcelEntity == null) {
                return;
            }
            bean.setWaybillNo(parcelEntity.getWaybillNo());
            bean.setReceiverName(parcelEntity.getReceiverName());
            bean.setReceiverTel(parcelEntity.getReceiverTel());
            bean.setReceiverAddr(parcelEntity.getReceiverAddr());
        });
        return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
    }
}

