/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.postcode.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.in.client.model.GetPostcodeListRequest;
import com.xforceplus.vanke.in.client.model.WkPostcodeDTO;
import com.xforceplus.vanke.in.service.postcode.PostcodeBusiness;
import com.xforceplus.vanke.sc.base.exception.VankeException;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPostcodeListProcess
extends AbstractProcess<GetPostcodeListRequest, ListResult<WkPostcodeDTO>> {
    @Autowired
    private PostcodeBusiness postcodeBusiness;

    protected void check(GetPostcodeListRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<ListResult<WkPostcodeDTO>> process(GetPostcodeListRequest request) throws RuntimeException {
        ListResult listResult = null;
        try {
            listResult = this.postcodeBusiness.getList(request);
        }
        catch (VankeException e) {
            return CommonResponse.failed((String)"\u9009\u62e9\u65e5\u671f\u4e0d\u53ef\u5927\u4e8e\u4e00\u5e74\u524d!");
        }
        ListResult result = new ListResult(listResult.getTotal(), listResult.getList().stream().map(entity -> {
            WkPostcodeDTO dto = new WkPostcodeDTO();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)result);
    }
}

