/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.postcode.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.SavePostcodeRequest;
import com.xforceplus.vanke.in.repository.dao.WkPostcodeDao;
import com.xforceplus.vanke.in.repository.model.WkPostcodeEntity;
import com.xforceplus.vanke.in.repository.model.WkPostcodeExample;
import com.xforceplus.vanke.sc.base.enums.LogisticsStatus.LogisticsExpressCodeEnum;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Date;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SavePostcodeProcess
extends AbstractProcess<SavePostcodeRequest, Long> {
    @Autowired
    private WkPostcodeDao wkPostcodeDao;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(SavePostcodeRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getPackageCode(), "\u90ae\u5305\u7684\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<Long> process(SavePostcodeRequest request) throws RuntimeException {
        int result;
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        WkPostcodeExample example = new WkPostcodeExample();
        example.createCriteria().andPackageCodeEqualTo(request.getPackageCode());
        WkPostcodeEntity entity = this.wkPostcodeDao.selectOneByExample(example);
        String message = "";
        if (entity == null) {
            entity = new WkPostcodeEntity();
            BeanUtils.copyProperties((Object)request, (Object)entity);
            entity.setRecieveTime(new Date());
            entity.setReciever(userSessionInfo.getSysUserName());
            result = this.wkPostcodeDao.insertSelective(entity);
            message = "\u7b7e\u6536\u6210\u529f";
        } else {
            entity.setRecieveTime(new Date());
            entity.setReciever(userSessionInfo.getSysUserName());
            LogisticsExpressCodeEnum logisticsExpressCodeEnum = LogisticsExpressCodeEnum.getExpressCode((String)entity.getPackageCode());
            entity.setExpressCode(logisticsExpressCodeEnum == null ? "" : logisticsExpressCodeEnum.getCode());
            result = this.wkPostcodeDao.updateByPrimaryKeySelective(entity);
            message = "\u8bf7\u6ce8\u610f\uff0c\u90ae\u5305\u5df2\u91cd\u590d\u7b7e\u6536\uff01";
        }
        if (result > 0) {
            return CommonResponse.ok((String)message, (Object)entity.getId());
        }
        return CommonResponse.failed((String)"\u7b7e\u6536\u5931\u8d25");
    }
}

