/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.report.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.repository.daoext.ReportDaoExt;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetDailyProcess
extends AbstractProcess<BaseRequest, Map> {
    @Autowired
    private ReportDaoExt reportDaoExt;

    protected CommonResponse<Map> process(BaseRequest request) throws RuntimeException {
        ConcurrentHashMap allMap = new ConcurrentHashMap();
        CompletableFuture<Map> ordersFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
            List ordersCount = this.reportDaoExt.getAllOrdersCount();
            map.put("allOrdersCount", (Integer)(ordersCount != null ? ordersCount.get(0) : Integer.valueOf(0)));
            map.put("dailyOrdersCount", (Integer)(ordersCount != null ? ordersCount.get(1) : Integer.valueOf(0)));
            map.put("monthOrdersCount", (Integer)(ordersCount != null ? ordersCount.get(2) : Integer.valueOf(0)));
            map.put("noHandleOrdersCount", (Integer)(ordersCount != null ? ordersCount.get(3) : Integer.valueOf(0)));
            return map;
        });
        CompletableFuture<Map> postcodeFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
            List postCodeCount = this.reportDaoExt.getAllPostCodeCount();
            map.put("allPostcodeCount", (Integer)(postCodeCount != null ? postCodeCount.get(0) : Integer.valueOf(0)));
            map.put("dailyPostcodeCount", (Integer)(postCodeCount != null ? postCodeCount.get(1) : Integer.valueOf(0)));
            map.put("monthPostcodeCount", (Integer)(postCodeCount != null ? postCodeCount.get(2) : Integer.valueOf(0)));
            map.put("noHandlePostcodeCount", (Integer)(postCodeCount != null ? postCodeCount.get(3) : Integer.valueOf(0)));
            return map;
        });
        CompletableFuture<Map> auditInvoiceFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
            List auditInvoiceCount = this.reportDaoExt.getAllAuditInvoiceCount();
            map.put("allAuditInvoiceCount", (Integer)(auditInvoiceCount != null ? auditInvoiceCount.get(0) : Integer.valueOf(0)));
            map.put("dailyAuditInvoiceCount", (Integer)(auditInvoiceCount != null ? auditInvoiceCount.get(1) : Integer.valueOf(0)));
            map.put("monthAuditInvoiceCount", (Integer)(auditInvoiceCount != null ? auditInvoiceCount.get(2) : Integer.valueOf(0)));
            map.put("noHandleAuditInvoiceCount", (Integer)(auditInvoiceCount != null ? auditInvoiceCount.get(3) : Integer.valueOf(0)));
            return map;
        });
        CompletableFuture<Map> authInvoiceFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
            List authInvoiceCount = this.reportDaoExt.getAllAuthInvoiceCount();
            map.put("allAuthInvoiceCount", (Integer)(authInvoiceCount != null ? authInvoiceCount.get(0) : Integer.valueOf(0)));
            map.put("dailyAuthInvoiceCount", (Integer)(authInvoiceCount != null ? authInvoiceCount.get(1) : Integer.valueOf(0)));
            map.put("monthAuthInvoiceCount", (Integer)(authInvoiceCount != null ? authInvoiceCount.get(2) : Integer.valueOf(0)));
            map.put("noHandleAuthInvoiceCount", (Integer)(authInvoiceCount != null ? authInvoiceCount.get(3) : Integer.valueOf(0)));
            return map;
        });
        CompletableFuture<Map> checkInvoiceFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
            List checkInvoiceCount = this.reportDaoExt.getAllCheckInvoiceCount();
            map.put("allCheckInvoiceCount", (Integer)(checkInvoiceCount != null ? checkInvoiceCount.get(0) : Integer.valueOf(0)));
            map.put("dailyCheckInvoiceCount", (Integer)(checkInvoiceCount != null ? checkInvoiceCount.get(1) : Integer.valueOf(0)));
            map.put("monthCheckInvoiceCount", (Integer)(checkInvoiceCount != null ? checkInvoiceCount.get(2) : Integer.valueOf(0)));
            map.put("noHandleCheckInvoiceCount", (Integer)(checkInvoiceCount != null ? checkInvoiceCount.get(3) : Integer.valueOf(0)));
            return map;
        });
        CompletableFuture<Map> imageInvoiceFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
            List imageInvoiceCount = this.reportDaoExt.getAllImageInvoiceCount();
            map.put("allImageInvoiceCount", (Integer)(imageInvoiceCount != null ? imageInvoiceCount.get(0) : Integer.valueOf(0)));
            map.put("dailyImageInvoiceCount", (Integer)(imageInvoiceCount != null ? imageInvoiceCount.get(1) : Integer.valueOf(0)));
            map.put("monthImageInvoiceCount", (Integer)(imageInvoiceCount != null ? imageInvoiceCount.get(2) : Integer.valueOf(0)));
            map.put("noHandleImageInvoiceCount", (Integer)(imageInvoiceCount != null ? imageInvoiceCount.get(3) : Integer.valueOf(0)));
            return map;
        });
        CompletableFuture<Map> signInvoiceFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
            List signInvoiceCount = this.reportDaoExt.getAllSignInvoiceCount();
            map.put("allSignInvoiceCount", (Integer)(signInvoiceCount != null ? signInvoiceCount.get(0) : Integer.valueOf(0)));
            map.put("dailySignInvoiceCount", (Integer)(signInvoiceCount != null ? signInvoiceCount.get(1) : Integer.valueOf(0)));
            map.put("monthSignInvoiceCount", (Integer)(signInvoiceCount != null ? signInvoiceCount.get(2) : Integer.valueOf(0)));
            map.put("noHandleSignInvoiceCount", (Integer)(signInvoiceCount != null ? signInvoiceCount.get(3) : Integer.valueOf(0)));
            return map;
        });
        CompletableFuture<Map> exceptionFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
            List exceptionCount = this.reportDaoExt.getAllExceptionCount();
            map.put("allExceptionCount", (Integer)(exceptionCount != null ? exceptionCount.get(0) : Integer.valueOf(0)));
            map.put("dailyExceptionCount", (Integer)(exceptionCount != null ? exceptionCount.get(1) : Integer.valueOf(0)));
            map.put("monthExceptionCount", (Integer)(exceptionCount != null ? exceptionCount.get(2) : Integer.valueOf(0)));
            map.put("noHandleExceptionCount", (Integer)(exceptionCount != null ? exceptionCount.get(3) : Integer.valueOf(0)));
            return map;
        });
        CompletableFuture<Void> allFuture = CompletableFuture.allOf(ordersFuture, postcodeFuture, auditInvoiceFuture, authInvoiceFuture, imageInvoiceFuture, signInvoiceFuture, exceptionFuture, checkInvoiceFuture);
        allFuture.join();
        allFuture.thenAccept(v -> Stream.of(ordersFuture, postcodeFuture, auditInvoiceFuture, authInvoiceFuture, imageInvoiceFuture, signInvoiceFuture, exceptionFuture, checkInvoiceFuture).forEach(r -> {
            try {
                allMap.putAll((Map)r.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }));
        return CommonResponse.ok((String)"", allMap);
    }
}

