/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.report.process;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetUserPerfRequest;
import com.xforceplus.vanke.in.client.model.UserPerfBean;
import com.xforceplus.vanke.in.client.model.UserPerfResultBean;
import com.xforceplus.vanke.in.repository.daoext.InvoiceDaoExt;
import com.xforceplus.vanke.in.repository.daoext.WkExceptionDaoExt;
import com.xforceplus.vanke.in.repository.daoext.WkOrdersDaoExt;
import com.xforceplus.vanke.in.repository.daoext.WkPostcodeDaoExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetUserPerfProcess
extends AbstractProcess<GetUserPerfRequest, List<UserPerfResultBean>> {
    @Autowired
    private WkPostcodeDaoExt wkPostcodeDaoExt;
    @Autowired
    private WkOrdersDaoExt wkOrdersDaoExt;
    @Autowired
    private InvoiceDaoExt invoiceDaoExt;
    @Autowired
    private WkExceptionDaoExt exceptionDaoExt;
    private Map<String, UserPerfResultBean> resultBeanMap = Maps.newHashMap();

    protected void check(GetUserPerfRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getWorkTime(), "\u65f6\u95f4\u533a\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<List<UserPerfResultBean>> process(GetUserPerfRequest request) throws RuntimeException {
        ArrayList futures = Lists.newArrayList();
        ArrayList resultBeanList = Lists.newArrayList();
        ArrayList userPerfBeanList = Lists.newArrayList();
        List<Integer> type = request.getRoleType();
        if (CollectionUtils.isEmpty((Collection)type)) {
            type = Arrays.asList(1, 2, 3, 4, 5);
        }
        int subDay = (int)(((Long)request.getWorkTime().get(1) - (Long)request.getWorkTime().get(0)) / 3600L / 24L);
        System.out.println(request.getWorkTime());
        Date date1 = new Date((Long)request.getWorkTime().get(0));
        Date date2 = new Date((Long)request.getWorkTime().get(1));
        request.setWorkStartTime(DateHelp.getTimeNormalString((Date)date1));
        request.setWorkEndTime(DateHelp.getTimeNormalString((Date)date2));
        request.setSubDay(Integer.valueOf(subDay));
        if (type.contains(1)) {
            CompletableFuture<List> postCodeFuture = CompletableFuture.supplyAsync(() -> {
                List postCodePerf = this.wkPostcodeDaoExt.getPerfPostCodeCount(request);
                return postCodePerf;
            });
            CompletableFuture<List> ordersFuture = CompletableFuture.supplyAsync(() -> {
                List ordersPerfCount = this.wkOrdersDaoExt.getPerfOrders(request);
                return ordersPerfCount;
            });
            CompletableFuture<List> signInvoiceFuture = CompletableFuture.supplyAsync(() -> {
                List signInvoicePerfCount = this.invoiceDaoExt.getSignPerfInvoice(request);
                return signInvoicePerfCount;
            });
            futures.add(postCodeFuture);
            futures.add(ordersFuture);
            futures.add(signInvoiceFuture);
        }
        if (type.contains(2)) {
            CompletableFuture<List> imageInvoiceFuture = CompletableFuture.supplyAsync(() -> {
                List imageInvoicePerfCount = this.invoiceDaoExt.getImagePerfInvoice(request);
                return imageInvoicePerfCount;
            });
            futures.add(imageInvoiceFuture);
        }
        if (type.contains(3)) {
            CompletableFuture<List> exceptionFuture = CompletableFuture.supplyAsync(() -> {
                List exceptionPerfCount = this.exceptionDaoExt.getPerfException(request);
                return exceptionPerfCount;
            });
            futures.add(exceptionFuture);
        }
        if (type.contains(4)) {
            CompletableFuture<List> authFuture = CompletableFuture.supplyAsync(() -> {
                List authPerfInvoice = this.invoiceDaoExt.getAuthPerfInvoice(request);
                return authPerfInvoice;
            });
            futures.add(authFuture);
        }
        if (type.contains(5)) {
            CompletableFuture<List> auditFuture = CompletableFuture.supplyAsync(() -> {
                List auditPerfInvoiceCount = this.invoiceDaoExt.getAuditPerfInvoice(request);
                return auditPerfInvoiceCount;
            });
            futures.add(auditFuture);
        }
        CompletableFuture<Void> allFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        allFuture.join();
        futures.stream().forEach(listCompletableFuture -> {
            try {
                userPerfBeanList.addAll((Collection)listCompletableFuture.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        });
        HashMap resultBeanMap = Maps.newHashMap();
        ArrayList nameList = Lists.newArrayList();
        for (UserPerfBean selectBean : userPerfBeanList) {
            UserPerfResultBean resultBean;
            if ("\u7cfb\u7edf".equals(selectBean.getUserName()) || "".equals(selectBean.getUserName()) || null == selectBean.getUserName()) continue;
            String name = selectBean.getUserName();
            if (nameList.contains(name)) {
                resultBean = (UserPerfResultBean)resultBeanMap.get(name);
                this.setUserPerfCount(resultBean, selectBean);
                resultBeanMap.put(name, resultBean);
                continue;
            }
            resultBean = new UserPerfResultBean();
            resultBean.setName(name);
            this.setUserPerfCount(resultBean, selectBean);
            nameList.add(name);
            resultBeanMap.put(name, resultBean);
        }
        for (String name : nameList) {
            resultBeanList.add(resultBeanMap.get(name));
        }
        return CommonResponse.ok((String)"", (Object)resultBeanList);
    }

    protected void setUserPerfCount(UserPerfResultBean bean, UserPerfBean userPerfBean) {
        switch (userPerfBean.getUserType()) {
            case 1: {
                bean.setPostCodeCount(userPerfBean.getWorkCount());
                bean.setPostCodeTimeLiness(userPerfBean.getTimeLiness());
                break;
            }
            case 2: {
                bean.setOrdersCodeCount(userPerfBean.getWorkCount());
                bean.setOrdersTimeLiness(userPerfBean.getTimeLiness());
                break;
            }
            case 3: {
                bean.setInvoiceCount(userPerfBean.getWorkCount());
                bean.setInvoiceTimeLiness(userPerfBean.getTimeLiness());
                break;
            }
            case 4: {
                bean.setImageCount(userPerfBean.getWorkCount());
                bean.setImageTimeLiness(userPerfBean.getTimeLiness());
                break;
            }
            case 5: {
                bean.setExceptionCount(userPerfBean.getWorkCount());
                bean.setExceptionTimeLiness(userPerfBean.getTimeLiness());
                break;
            }
            case 6: {
                bean.setAuthCount(userPerfBean.getWorkCount());
                bean.setAuthTimeLiness(userPerfBean.getTimeLiness());
                break;
            }
            case 7: {
                bean.setAuditCount(userPerfBean.getWorkCount());
                bean.setAuditTimeLiness(userPerfBean.getWorkCount());
            }
        }
    }
}

